<?php
/**
 * DashboardAppAsset.php
 * ABM
 * Copyright ©: 2019 Integrasoft. Todos los derechos reservados.
 * Desarrollador(es):
 *      L.I. Humberto Javier Flores Tirado.
 * Fecha de creación: 05/10/18.
 * Fecha de modificación: 08/10/18.
 * Descripción:
 */

namespace app\assets;

use yii\web\AssetBundle;

/**
 * Main application asset bundle.
 *
 * @author Qiang Xue <qiang.xue@gmail.com>
 * @since 2.0
 */
class DashboardAppAsset extends AssetBundle
{
    public $basePath = '@webroot';
    public $baseUrl = '@web';
    public $css = [
        'css/site.css',

        //'themes/AdminLTE/bower_components/jquery-ui/themes/smoothness/jquery-ui.min.css',
        //'themes/AdminLTE/bower_components/boostrap/dist/bootstrap.min.css',
        'themes/AdminLTE/bower_components/font-awesome/css/font-awesome.min.css',
        'themes/AdminLTE/bower_components/Ionicons/css/ionicons.min.css',
        'themes/AdminLTE/dist/css/AdminLTE.min.css',
        'themes/AdminLTE/dist/css/skins/_all-skins.min.css',

        'themes/AdminLTE/bower_components/morris.js/morris.css',
        'themes/AdminLTE/bower_components/jvectormap/jquery-jvectormap.css',
        'themes/AdminLTE/bower_components/bootstrap-datepicker/dist/css/bootstrap-datepicker.min.css',
        'themes/AdminLTE/bower_components/bootstrap-daterangepicker/daterangepicker.css',
        'themes/AdminLTE/plugins/bootstrap-wysihtml5/bootstrap3-wysihtml5.min.css',
        //'https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,600,700,300italic,400italic,600italic',

    ];
    public $js = [
        'https://oss.maxcdn.com/html5shiv/3.7.3/html5shiv.min.js',
        'https://oss.maxcdn.com/respond/1.4.2/respond.min.js',
        //'themes/AdminLTE/bower_components/jquery/dist/jquery.min.js',
        //'themes/AdminLTE/bower_components/jquery-ui/jquery-ui.min.js',
        //'themes/AdminLTE/bower_components/bootstrap/dist/js/bootstrap.min.js',
        'themes/AdminLTE/bower_components/raphael/raphael.min.js',
        'themes/AdminLTE/bower_components/morris.js/morris.min.js',
        'themes/AdminLTE/bower_components/jquery-sparkline/dist/jquery.sparkline.min.js',
        'themes/AdminLTE/plugins/jvectormap/jquery-jvectormap-1.2.2.min.js',
        'themes/AdminLTE/plugins/jvectormap/jquery-jvectormap-world-mill-en.js',
        'themes/AdminLTE/bower_components/jquery-knob/dist/jquery.knob.min.js',
        'themes/AdminLTE/bower_components/moment/min/moment.min.js',
        'themes/AdminLTE/bower_components/bootstrap-daterangepicker/daterangepicker.js',
        'themes/AdminLTE/bower_components/bootstrap-datepicker/dist/js/bootstrap-datepicker.min.js',
        'themes/AdminLTE/plugins/bootstrap-wysihtml5/bootstrap3-wysihtml5.all.min.js',


        'themes/AdminLTE/bower_components/jquery-slimscroll/jquery.slimscroll.min.js',
        'themes/AdminLTE/bower_components/fastclick/lib/fastclick.js',
        'themes/AdminLTE/dist/js/adminlte.min.js',


        //'themes/AdminLTE/dist/js/pages/dashboard.js',
        //'themes/AdminLTE/dist/js/demo.js',
    ];
    public $depends = [
        'yii\web\YiiAsset',
        'yii\bootstrap\BootstrapAsset',
        'yii\bootstrap\BootstrapPluginAsset',
    ];
}
