<?php
/**
 * DashboardColorAdminAppAsset.php
 * ABM
 * Copyright ©: 2019 Integrasoft. Todos los derechos reservados.
 * Desarrollador(es):
 *      L.I. Humberto Javier Flores Tirado.
 * Fecha de creación: 19/06/2019.
 * Fecha de modificación: 09/08/2019.
 * Descripción:
 */

namespace app\assets;

use yii\web\AssetBundle;

/**
 * Main application asset bundle.
 *
 * @author Qiang Xue <qiang.xue@gmail.com>
 * @since 2.0
 */
class DashboardColorAdminAppAsset extends AssetBundle
{
    public $basePath = '@webroot';
    public $baseUrl = '@web';
    public $css = [
        //'css/site.css',

        '//fonts.googleapis.com/css?family=Open+Sans:300,400,600,700',
        'themes/ColorAdmin/plugins/jquery-ui/jquery-ui.min.css',
        'themes/ColorAdmin/plugins/bootstrap/css/bootstrap.min.css',
        'themes/ColorAdmin/plugins/font-awesome/css/all.min.css',
        'themes/ColorAdmin/plugins/animate/animate.min.css',
        'themes/ColorAdmin/css/default/style.min.css',
        'themes/ColorAdmin/css/default/style-responsive.min.css',
        'themes/ColorAdmin/css/default/theme/default.css',

        'themes/ColorAdmin/plugins/jquery-jvectormap/jquery-jvectormap.css',
        'themes/ColorAdmin/plugins/bootstrap-datepicker/css/bootstrap-datepicker.css',
        'themes/ColorAdmin/plugins/gritter/css/jquery.gritter.css',
        'themes/ColorAdmin/plugins/DataTables/media/css/dataTables.bootstrap.min.css',
        'themes/ColorAdmin/plugins/DataTables/extensions/Responsive/css/responsive.bootstrap.min.css',

        'themes/ColorAdmin/plugins/bootstrap-datepicker/css/bootstrap-datepicker.css',
        'themes/ColorAdmin/plugins/bootstrap-datepicker/css/bootstrap-datepicker3.css',
        'themes/ColorAdmin/plugins/ionRangeSlider/css/ion.rangeSlider.css',
        'themes/ColorAdmin/plugins/ionRangeSlider/css/ion.rangeSlider.skinNice.css',
        'themes/ColorAdmin/plugins/bootstrap-colorpicker/css/bootstrap-colorpicker.min.css',
        'themes/ColorAdmin/plugins/bootstrap-timepicker/css/bootstrap-timepicker.min.css',
        'themes/ColorAdmin/plugins/password-indicator/css/password-indicator.css',
        'themes/ColorAdmin/plugins/bootstrap-combobox/css/bootstrap-combobox.css',
        'themes/ColorAdmin/plugins/bootstrap-select/bootstrap-select.min.css',
        'themes/ColorAdmin/plugins/bootstrap-tagsinput/bootstrap-tagsinput.css',
        'themes/ColorAdmin/plugins/jquery-tag-it/css/jquery.tagit.css',
        'themes/ColorAdmin/plugins/bootstrap-daterangepicker/daterangepicker.css',
        'themes/ColorAdmin/plugins/select2/dist/css/select2.min.css',
        'themes/ColorAdmin/plugins/bootstrap-eonasdan-datetimepicker/build/css/bootstrap-datetimepicker.min.css',
        'themes/ColorAdmin/plugins/bootstrap-colorpalette/css/bootstrap-colorpalette.css',
        'themes/ColorAdmin/plugins/jquery-simplecolorpicker/jquery.simplecolorpicker.css',
        'themes/ColorAdmin/plugins/jquery-simplecolorpicker/jquery.simplecolorpicker-fontawesome.css',
        'themes/ColorAdmin/plugins/jquery-simplecolorpicker/jquery.simplecolorpicker-glyphicons.css',
        'themes/ColorAdmin/css/default/theme/default.css',
        'themes/ColorAdmin/plugins/nvd3/build/nv.d3.css',
        'themes/ColorAdmin/plugins/bootstrap-select/bootstrap-select.min.css',
        'themes/ColorAdmin/plugins/select2/dist/css/select2.min.css',
        'themes/ColorAdmin/plugins/isotope/isotope.css',
        'themes/ColorAdmin/plugins/lightbox/css/lightbox.css',
        'css/glyphicon.css',
    ];
    public $js = [
        'themes/ColorAdmin/plugins/pace/pace.min.js',
        //'themes/ColorAdmin/plugins/jquery/jquery-3.3.1.min.js',
        'themes/ColorAdmin/plugins/jquery-ui/jquery-ui.min.js',
        'themes/ColorAdmin/plugins/bootstrap/js/bootstrap.bundle.min.js',

        'themes/ColorAdmin/plugins/slimscroll/jquery.slimscroll.min.js',
        'themes/ColorAdmin/plugins/js-cookie/js.cookie.js',
        'themes/ColorAdmin/js/theme/default.min.js',
        'themes/ColorAdmin/js/apps.min.js',

        'themes/ColorAdmin/plugins/DataTables/media/js/jquery.dataTables.js',
        'themes/ColorAdmin/plugins/DataTables/media/js/dataTables.bootstrap.min.js',
        'themes/ColorAdmin/plugins/DataTables/extensions/Responsive/js/dataTables.responsive.min.js',
        'themes/ColorAdmin/js/demo/table-manage-default.demo.min.js',

        'themes/ColorAdmin/plugins/highlight/highlight.common.js',
        'themes/ColorAdmin/js/demo/render.highlight.js',

        'themes/ColorAdmin/plugins/gritter/js/jquery.gritter.js',
        'themes/ColorAdmin/plugins/flot/jquery.flot.min.js',
        'themes/ColorAdmin/plugins/flot/jquery.flot.time.min.js',
        'themes/ColorAdmin/plugins/flot/jquery.flot.resize.min.js',
        'themes/ColorAdmin/plugins/flot/jquery.flot.pie.min.js',
        'themes/ColorAdmin/plugins/sparkline/jquery.sparkline.js',
        'themes/ColorAdmin/plugins/jquery-jvectormap/jquery-jvectormap.min.js',
        'themes/ColorAdmin/plugins/jquery-jvectormap/jquery-jvectormap-world-mill-en.js',
        'themes/ColorAdmin/plugins/bootstrap-datepicker/js/bootstrap-datepicker.js',

        'themes/ColorAdmin/plugins/ionRangeSlider/js/ion-rangeSlider/ion.rangeSlider.min.js',
        'themes/ColorAdmin/plugins/bootstrap-colorpicker/js/bootstrap-colorpicker.min.js',
        'themes/ColorAdmin/plugins/masked-input/masked-input.min.js',
        'themes/ColorAdmin/plugins/bootstrap-timepicker/js/bootstrap-timepicker.min.js',
        'themes/ColorAdmin/plugins/password-indicator/js/password-indicator.js',
        'themes/ColorAdmin/plugins/bootstrap-combobox/js/bootstrap-combobox.js',
        'themes/ColorAdmin/plugins/bootstrap-select/bootstrap-select.min.js',
        'themes/ColorAdmin/plugins/bootstrap-sweetalert/sweetalert.min.js',
        'themes/ColorAdmin/plugins/bootstrap-tagsinput/bootstrap-tagsinput.min.js',
        'themes/ColorAdmin/plugins/bootstrap-tagsinput/bootstrap-tagsinput-typeahead.js',
        'themes/ColorAdmin/plugins/jquery-tag-it/js/tag-it.min.js',
        'themes/ColorAdmin/plugins/bootstrap-daterangepicker/moment.js',
        'themes/ColorAdmin/plugins/bootstrap-daterangepicker/daterangepicker.js',
        'themes/ColorAdmin/plugins/select2/dist/js/select2.js',
        'themes/ColorAdmin/plugins/bootstrap-eonasdan-datetimepicker/build/js/bootstrap-datetimepicker.min.js',
        'themes/ColorAdmin/plugins/bootstrap-show-password/bootstrap-show-password.js',
        'themes/ColorAdmin/plugins/bootstrap-colorpalette/js/bootstrap-colorpalette.js',
        'themes/ColorAdmin/plugins/jquery-simplecolorpicker/jquery.simplecolorpicker.js',
        'themes/ColorAdmin/plugins/clipboard/clipboard.min.js',
        'themes/ColorAdmin/js/demo/form-plugins.demo.min.js',

        'themes/ColorAdmin/js/demo/dashboard.min.js',
        'js/dashboard-color-admin.js',

        'themes/ColorAdmin/plugins/d3/d3.min.js',
        'themes/ColorAdmin/plugins/nvd3/build/nv.d3.js',
        
        'themes/ColorAdmin/plugins/isotope/jquery.isotope.min.js',
        'themes/ColorAdmin/plugins/lightbox/js/lightbox.min.js',
        'themes/ColorAdmin/js/demo/gallery.demo.min.js'
        //'themes/ColorAdmin/js/demo/chart-d3.demo.js',
    ];
    public $depends = [
        'yii\web\YiiAsset',
        //'yii\bootstrap\BootstrapAsset',
        //'yii\bootstrap\BootstrapPluginAsset',
    ];
}
