<?php

$params = require __DIR__ . '/params.php';
$db = require __DIR__ . '/db.php';
$db_logs = require __DIR__ . '/db_logs.php';

$config = [
    'id' => 'basic',
    'name' => 'Springfield',
    'basePath' => dirname(__DIR__),
    'bootstrap' => ['log'],
    //'defaultRoute' => 'sesion/iniciar',
    'timeZone' => 'America/Mexico_City',
    'aliases' => [
        '@bower' => '@vendor/bower-asset',
        '@npm'   => '@vendor/npm-asset',
    ],
    'components' => [
        /*
        'assetManager' => [
            'bundles' => [
                'yii\web\JqueryAsset' => false,
            ],
        ],
        */

        'request' => [
            // !!! insert a secret key in the following (if it is empty) - this is required by cookie validation
            'cookieValidationKey' => 'Dbzrjso0BRRF2EyiJZZwDSmkZ3Ftc1i5',
        ],
        'cache' => [
            'class' => 'yii\caching\FileCache',
        ],
        'session' => [
            'timeout' => 3600, // 2 weeks, 3600 - 1 hour, Default 1440
        ],
        'user' => [
            //'identityClass' => 'app\models\User',
            //'enableAutoLogin' => true,
            'identityClass' => 'app\models\sesion\UsuarioSesion',
            'loginUrl' => ['sesion/iniciar'], //Esta l铆nea es para cuando no se tiene acceso redirecci贸n a esta pantalla
            'enableAutoLogin' => false,
        ],
        'errorHandler' => [
            //'errorAction' => 'site/error',
            'errorAction' => 'sesion/error',
        ],
        'mailer' => [
            'class' => 'yii\swiftmailer\Mailer',
            // send all mails to a file by default. You have to set
            // 'useFileTransport' to false and configure a transport
            // for the mailer to send real emails.
            //'useFileTransport' => true,
            /*'useFileTransport' => false,
            'transport' => [
                'class' => 'Swift_SmtpTransport',
                'host' => 'localhost',//'host' => 'smtp.office365.com',
                //'username' => 'integrasoft@procesosdeenfriamiento.com.mx',
                //'password' => '%&T3stiN61n73g84#',
                'port' => '25',
                'encryption' => 'ssl', //'encryption' => 'tls',
            ],*/

            'transport' => [
                'class' => 'Swift_SmtpTransport',
                'host' => 'smtp.office365.com',
                //'username' => 'integrasoft@procesosdeenfriamiento.com.mx',
                //'password' => '%&T3stiN61n73g84#',
                'username' => 'jflores@integrasoft.mx',
                'password' => '',
                'port' => '25',
                'encryption' => 'ssl', //'encryption' => 'tls',
            ],
        ],
        'log' => [
            'traceLevel' => YII_DEBUG ? 3 : 0,
            'targets' => [
                [
                    'class' => 'yii\log\FileTarget',
                    'levels' => ['error', 'warning'],
                ],
            ],
        ],
        'db' => $db,
        'db_logs' => $db_logs,
        'urlManager' => [
            'enablePrettyUrl' => true,
            'showScriptName' => false,
            'rules' => [
                'login' => 'SesionController/ActionIniciar',
            ],
        ],
        'defaultRoute' => 'sesion/iniciar',
        'formatter' => [
            'class' => 'yii\i18n\Formatter',
            'nullDisplay' => '',
        ],
    ],
    'params' => $params,
];

if (YII_ENV_DEV) {
    // configuration adjustments for 'dev' environment
    $config['bootstrap'][] = 'debug';
    $config['modules']['debug'] = [
        'class' => 'yii\debug\Module',
        // uncomment the following to add your IP if you are not connecting from localhost.
        //'allowedIPs' => ['127.0.0.1', '::1'],
    ];

    $config['bootstrap'][] = 'gii';
    $config['modules']['gii'] = [
        'class' => 'yii\gii\Module',
        // uncomment the following to add your IP if you are not connecting from localhost.
        //LA L脥NEA DE ABAJO ES IMPORTANTE SI TE ESTAS CONECTANDO DESDE OTRO EQUIPOO A GII
        'allowedIPs' => ['127.0.0.1', '::1', '192.168.64.*'],
    ];
}

return $config;
