<?php
/*
 * SiteController.php
 * Reporte Móvil
 * Copyright ©: 2018 Integrasoft. Todos los derechos reservados.
 * Desarrollador(es):
 *      L.I. Humberto Javier Flores Tirado.
 * Fecha de creación: 30/08/18.
 * Fecha de modificación: 05/10/18.
 * Descripción:
 */

namespace app\controllers;


use app\models\util\Utils;
use Yii;
use yii\filters\AccessControl;
use yii\web\Controller;
use yii\web\Response;
use yii\filters\VerbFilter;
use yii\helpers\Url;

use app\models\log\BitacoraUsuario;
use app\models\log\BitacoraSistema;
use Mpdf\Mpdf;

/**
 * Clase controlador del sitio.
 *
 * Class SiteController
 * @package app\controllers
 */
class SiteController extends Controller
{
    //public $successUrl = 'Success';
    public $controlador;
    private $logu;
    private $logs;
    public $enableCsrfValidation = false;

    /**
     * @inheritdoc
     */
    public function behaviors()
    {
        return [
            'access' => [
                'class' => AccessControl::className(),
                'only' => ['logout'],
                'rules' => [
                    [
                        'actions' => ['logout'],
                        'allow' => true,
                        'roles' => ['@'],
                    ],
                ],
            ],
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'logout' => ['post'],
                ],
            ],

        ];
    }

    /**
     * Método que permitite definir operaciones previas a que se ejecute un action.
     *
     * @param \yii\base\Action $action
     * @return bool
     * @throws \yii\web\BadRequestHttpException
     */
    public function beforeAction($action)
    {
        //PERMITE DESHABILITA DESHABILITAR EL TOKEN DE SEGURIDAD CUANDO SE ENVÍAN LOS FORMULARIOS
        if(in_array($action->id, ['formulario']))
        {
            $this->enableCsrfValidation = false;
        }

        return parent::beforeAction($action);
    }

    /**
     * @inheritdoc
     */
    public function actions()
    {
        $this->layout = "index";
        $this->controlador = "SiteController";
        $this->logu = new BitacoraUsuario();
        $this->logs = new BitacoraSistema();

        return [
            'error' => [
                'class' => 'yii\web\ErrorAction',
            ],
            'captcha' => [
                'class' => 'yii\captcha\CaptchaAction',
                'fixedVerifyCode' => YII_ENV_TEST ? 'testme' : null,
            ],
            'auth' => [
                'class' => 'yii\authclient\AuthAction',
                'successCallback' => [$this, 'oAuthSuccess'],
            ],
        ];
    }

    /**
     * Método que muestra la página principal del sitio.
     *
     * @return string
     */
    public function actionIndex() {
        //return $this->render('index');
        return $this->redirect(Yii::getAlias('@web') . '/sesion/');
        /*
        $carrusel = Carrusel::findOne(1);
        $numeroTotalReportes = Reporte::find()->count();
        $numeroReportesAtendiendo = Reporte::find()->where(['idEstatusReporte' => 3])->count();
        $numeroReportesCerrados = Reporte::find()->where(['idEstatusReporte' => 5])->count();
        $numeroTotalCiudadanos = Ciudadano::find()->count();

        return $this->render('index',
            [
                'carrusel' => $carrusel,
                'numeroTotalReportes' => $numeroTotalReportes,
                'numeroTotalCiudadanos' => $numeroTotalCiudadanos,
                'numeroReportesCerrados' => $numeroReportesCerrados,
                'numeroReportesAtendiendo' => $numeroReportesAtendiendo,
            ]);
        */
    }

    public function actionFormulario() {
        $nombreArchivo = "1_iniciativa.png";
        $rutaArchivo = Yii::$app->basePath . "/" . Yii::$app->params['ruta-archivos-iniciativa'] . $nombreArchivo;

        Utils::visualizarArchivo($rutaArchivo, $nombreArchivo);



    }

    public function actionProbar() {
        //$model = new Iniciativa();
        //$html = $this->renderPartial('../vista/_pdf', ['model' => $model]);
        $tmpPDF = Yii::$app->basePath . "/" . Yii::$app->params['ruta-tmp-pdf'];

        $pdf = new Mpdf([
            'tempDir' => $tmpPDF,
            'mode' => 'utf-8',
            'format' => 'Letter',
            'orientation' => 'P',
        ]);

        $pdf->SetHeader("Cabecera");
        $pdf->WriteHTML("<bold>hola</bold>");
        $pdf->Output();
    }
}
