<?php
/*
 * AntecedenteAcademico.php
 * Springfield
 * Copyright ©: 2022 Integrasoft. Todos los derechos reservados.
 * Desarrollador(es):
 *      I.S.C Julio Alberto Ocampo Rangel
 * Fecha de creación: 27/03/2022.
 * Fecha de modificación: 27/03/2022.
 * Descripción:
 */
namespace app\models\antecedenteacademico;

use Yii;
use yii\db\ActiveRecord;
use app\models\sustentante\Sustentante;

/**
 * Clase modelo de la tabla "AntecedenteAcademico".
 *
 * @property int $idAntecedenteAcademico
 * @property string $antecedenteAcademico
 *
 * @property Sustentante[] $sustentantes
 */
class AntecedenteAcademico extends ActiveRecord
{
    /**
     * Método que devuelve la tabla de la que es modelo la clase.
     */
    public static function tableName()
    {
        return 'AntecedenteAcademico';
    }

    /**
     * Método que define las validaciones de los atributos.
     */
    public function rules()
    {
        return [
            [['antecedenteAcademico'], 'required'],
            [['antecedenteAcademico'], 'string', 'max' => 100],
        ];
    }

    /**
     * Método que define las etiquetas de los atributos.
     */
    public function attributeLabels()
    {
        return [
            'idAntecedenteAcademico' => 'ID',
            'antecedenteAcademico' => 'Antecedente académico',
        ];
    }

    /**
     * @return ActiveQuery
     */
    public function getSustentantes()
    {
        return $this->hasMany(Sustentante::class, ['idAntecedenteAcademico' => 'idAntecedenteAcademico']);
    }
}
