<?php
/*
 * AreaConocimiento.php
 * Springfield
 * Copyright ©: 2022 Integrasoft. Todos los derechos reservados.
 * Desarrollador(es):
 *      I.S.C Julio Alberto Ocampo Rangel
 * Fecha de creación: 27/03/2022.
 * Fecha de modificación: 27/03/2022.
 * Descripción:
 */
namespace app\models\areaconocimiento;

use Yii;
use yii\db\ActiveRecord;
use app\models\perfilprofesional\PerfilProfesional;

/**
 * Clase modelo de la tabla "AreaConocimiento".
 *
 * @property int $idAreaConocimiento
 * @property string $areaConocimiento
 *
 * @property PerfilProfesional[] $perfilProfesionals
 */
class AreaConocimiento extends ActiveRecord
{
    /**
     * Método que devuelve la tabla de la que es modelo la clase.
     */
    public static function tableName()
    {
        return 'AreaConocimiento';
    }

    /**
     * Método que define las validaciones de los atributos.
     */
    public function rules()
    {
        return [
            [['areaConocimiento'], 'required'],
            [['areaConocimiento'], 'string', 'max' => 100],
        ];
    }

    /**
     * Método que define las etiquetas de los atributos.
     */
    public function attributeLabels()
    {
        return [
            'idAreaConocimiento' => 'ID',
            'areaConocimiento' => 'Área de conocimiento',
        ];
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getPerfilProfesionales()
    {
        return $this->hasMany(PerfilProfesional::class, ['idAreaConocimiento' => 'idAreaConocimiento']);
    }
}
