<?php
/*
 * MotivoNoConcluyo.php
 * Springfield
 * Copyright ©: 2022 Integrasoft. Todos los derechos reservados.
 * Desarrollador(es):
 *      I.S.C Julio Alberto Ocampo Rangel
 *      L.I. Humberto Javier Flores Tirado
 * Fecha de creación: 27/03/2022.
 * Fecha de modificación: 29/03/2022.
 * Descripción:
 */

namespace app\models\estado;

use Yii;

/**
 * This is the model class for table "Estado".
 *
 * @property int $idEstado
 * @property string $estado
 *
 * @property Sede[] $sedes
 * @property Sustentante[] $sustentantes
 * @property Sustentante[] $sustentantes0
 * @property Usuario[] $usuarios
 */
class Estado extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'Estado';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['estado'], 'required'],
            [['estado'], 'string', 'max' => 100],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'idEstado' => 'Id Estado',
            'estado' => 'Estado',
        ];
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getSedes()
    {
        return $this->hasMany(Sede::className(), ['idEstado' => 'idEstado']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getSustentantes()
    {
        return $this->hasMany(Sustentante::className(), ['idEstado' => 'idEstado']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getSustentantes0()
    {
        return $this->hasMany(Sustentante::className(), ['idEstadoRadica' => 'idEstado']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getUsuarios()
    {
        return $this->hasMany(Usuario::className(), ['idEstado' => 'idEstado']);
    }
}
