<?php
/*
 * EstatusSustentante.php
 * Springfield
 * Copyright ©: 2022 Integrasoft. Todos los derechos reservados.
 * Desarrollador(es):
 *      I.S.C Julio Alberto Ocampo Rangel
 * Fecha de creación: 28/03/2022.
 * Fecha de modificación: 28/03/2022.
 * Descripción:
 */
namespace app\models\estatussustentante;

use Yii;
use yii\db\ActiveRecord;
use app\models\sustentante\Sustentante;

/**
 * Clase modelo de la tabla "EstatusSustentante".
 *
 * @property int $idEstatusSustentante
 * @property string $estatusSustentante
 *
 * @property Sustentante[] $sustentantes
 */
class EstatusSustentante extends ActiveRecord
{
    /**
     * Método que devuelve la tabla de la que es modelo la clase.
     */
    public static function tableName()
    {
        return 'EstatusSustentante';
    }

    /**
     * Método que define las validaciones de los atributos.
     */
    public function rules()
    {
        return [
            [['estatusSustentante'], 'required'],
            [['estatusSustentante'], 'string', 'max' => 50],
        ];
    }

    /**
     * Método que define las etiquetas de los atributos.
     */
    public function attributeLabels()
    {
        return [
            'idEstatusSustentante' => 'ID',
            'estatusSustentante' => 'Estatus sustentante',
        ];
    }

    /**
     * @return ActiveQuery
     */
    public function getSustentantes()
    {
        return $this->hasMany(Sustentante::class, ['idEstatusSustentante' => 'idEstatusSustentante']);
    }
}
