<?php
/*
 * BitacoraSistema.php
 * Springfield
 * Copyright ©: 2022 Integrasoft. Todos los derechos reservados.
 * Desarrollador(es):
 *      L.I. Humberto Javier Flores Tirado.
 * Fecha de creación: 25/03/2022.
 * Fecha de modificación: 25/03/2022.
 * Descripción:
 */

namespace app\models\log;

use Yii;
use yii\db\ActiveRecord;
use yii\db\Expression;

/**
 * Clase modelo de la tabla "AplBitacoraSistema".
 *
 * @property int $idBitacoraSistema
 * @property int $idUsuario
 * @property int $idRolUsuario
 * @property string $dated
 * @property string $remoteIP
 * @property string $levelMessage
 * @property string $logger
 * @property string $message
 */
class BitacoraSistema extends ActiveRecord
{
    /* ########## MÉTODOS PARA DEFINICIÓN DE PARÁMETROS Y REGLAS DEL MODELO DE BASE DE DATOS ########## */

    /**
     * Método que devuelve la tabla de la que es modelo la clase.
     *
     * @return string
     */
    public static function tableName()
    {
        return 'AplBitacoraSistema';
    }

    /**
     * Método que devuelve el nombre a la base de datos en la que funcionará.
     *
     * @return \yii\db\Connection the database connection used by this AR class.
     */
    public static function getDb()
    {
        return Yii::$app->get('db_logs');
    }

    /**
     * Método que define las validaciones de los atributos.
     *
     * @return array
     */
    public function rules()
    {
        return [
            [['idUsuario', 'idRolUsuario'], 'integer'],
            [['dated', 'levelMessage', 'logger', 'message'], 'required'],
            [['dated'], 'safe'],
            [['remoteIP', 'levelMessage', 'logger', 'message'], 'string'],
        ];
    }

    /**
     * Método que define las etiquetas de los atributos.
     *
     * @return array
     */
    public function attributeLabels()
    {
        return [
            'idBitacoraSistema' => 'ID',
            'idUsuario' => 'Usuario',
            'idRolUsuario' => 'Rol de usuario',
            'dated' => 'Dated',
            'remoteIP' => 'Remote IP',
            'levelMessage' => 'Level Message',
            'logger' => 'Logger',
            'message' => 'Message',
        ];
    }

    /* ########## MÉTODOS PARA OPERACIONES SOBRE BASE DE DATOS ########## */

    /**
     * Método que registra en la bitácora de sistema.
     *
     * @param $idUsuario
     * @param $idRolUsuario
     * @param $levelMessage
     * @param $logger
     * @param $message
     * @throws \Exception
     */
    public function registrar($idUsuario, $idRolUsuario, $levelMessage, $logger, $message)
    {
        $this->idUsuario = $idUsuario;
        $this->idRolUsuario = $idRolUsuario;
        $this->levelMessage = $levelMessage;
        $this->logger = $logger;
        $this->message = $message;
        $this->dated = new Expression('NOW()');
        $this->remoteIP = Yii::$app->params['ip'];

        if(!$this->save(false))
        {
            $error = print_r($this->getErrors(), true);
            throw new \Exception($error);
        }
    }
}

?>