<?php
/*
 * BitacoraUsuario.php
 * Springfield
 * Copyright ©: 2022 Integrasoft. Todos los derechos reservados.
 * Desarrollador(es):
 *      L.I. Humberto Javier Flores Tirado.
 * Fecha de creación: 25/03/2022.
 * Fecha de modificación: 25/03/2022.
 * Descripción:
 */

namespace app\models\log;

use Yii;
use yii\db\ActiveRecord;
use yii\db\Expression;

/**
 * Clase modelo de la tabla "DatBitacoraUsuario".
 *
 * @property int $idBitacoraUsuario
 * @property string $fechaOperacion
 * @property int $idUsuario
 * @property int $idRolUsuario
 * @property string $remoteIP
 * @property string $mensaje
 * @property int $operacionExitosa
 */
class BitacoraUsuario extends ActiveRecord
{
    /* ########## MÉTODOS PARA DEFINICIÓN DE PARÁMETROS Y REGLAS DEL MODELO DE BASE DE DATOS ########## */

    /**
     * Método que devuelve la tabla de la que es modelo la clase.
     *
     * @return string
     */
    public static function tableName()
    {
        return 'DatBitacoraUsuario';
    }

    /**
     * Método que devuelve el nombre a la base de datos en la que funcionará.
     *
     * @return \yii\db\Connection the database connection used by this AR class.
     */
    public static function getDb()
    {
        return Yii::$app->get('db_logs');
    }

    /**
     * Método que define las validaciones de los atributos.
     *
     * @return array
     */
    public function rules()
    {
        return [
            [['fechaOperacion', 'idUsuario', 'remoteIP', 'mensaje', 'operacionExitosa'], 'required'],
            [['fechaOperacion'], 'safe'],
            [['idUsuario', 'idRolUsuario', 'operacionExitosa'], 'integer'],
            [['remoteIP', 'mensaje'], 'string'],
        ];
    }

    /**
     * Método que define las etiquetas de los atributos.
     *
     * @return array
     */
    public function attributeLabels()
    {
        return [
            'idBitacoraUsuario' => 'ID',
            'fechaOperacion' => 'Fecha de operación',
            'idUsuario' => 'Usuario',
            'idRolUsuario' => 'Rol de usuario',
            'remoteIP' => 'Remote IP',
            'mensaje' => 'Mensaje',
            'operacionExitosa' => 'Operacion exitosa',
        ];
    }

    /* ########## MÉTODOS PARA OPERACIONES SOBRE BASE DE DATOS ########## */

    /**
     * Método que registra en la bitácora de usuario.
     *
     * @param $idUsuario
     * @param $idRolUsuario
     * @param $mensaje
     * @param $operacionExitosa
     * @throws \Exception
     */
    public function registrar($idUsuario, $idRolUsuario, $mensaje, $operacionExitosa) {
        $this->idUsuario = $idUsuario;
        $this->idRolUsuario = $idRolUsuario;
        $this->mensaje = $mensaje;
        $this->operacionExitosa = $operacionExitosa;
        $this->fechaOperacion = new Expression('NOW()');
        $this->remoteIP = Yii::$app->params['ip'];

        if(!$this->save(false)) {
            $error = print_r($this->getErrors(), true);
            throw new \Exception($error);
        }
    }
}

?>