<?php
/*
 * MotivoNoConcluyo.php
 * Springfield
 * Copyright ©: 2022 Integrasoft. Todos los derechos reservados.
 * Desarrollador(es):
 *      I.S.C Julio Alberto Ocampo Rangel
 * Fecha de creación: 27/03/2022.
 * Fecha de modificación: 27/03/2022.
 * Descripción:
 */
namespace app\models\motivonoconcluyo;

use Yii;
use yii\db\ActiveRecord;
use app\models\sustentante\Sustentante;

/**
 * Clase modelo de la tabla "MotivoNoConcluyo".
 *
 * @property int $idMotivoNoConcluyo
 * @property string $motivoNoConcluyo
 *
 * @property Sustentante[] $sustentantes
 */
class MotivoNoConcluyo extends ActiveRecord
{
    /**
     * Método que devuelve la tabla de la que es modelo la clase.
     */
    public static function tableName()
    {
        return 'MotivoNoConcluyo';
    }

    /**
     * Método que define las validaciones de los atributos.
     */
    public function rules()
    {
        return [
            [['motivoNoConcluyo'], 'required'],
            [['motivoNoConcluyo'], 'string', 'max' => 100],
        ];
    }

    /**
     * Método que define las etiquetas de los atributos.
     */
    public function attributeLabels()
    {
        return [
            'idMotivoNoConcluyo' => 'ID',
            'motivoNoConcluyo' => 'Motivo por el cual no concluyó sus estudios o no se tituló',
        ];
    }

    /**
     * @return ActiveQuery
     */
    public function getSustentantes()
    {
        return $this->hasMany(Sustentante::class, ['idMotivoNoConcluyo' => 'idMotivoNoConcluyo']);
    }
}
