<?php
/*
 * MotivoNoConcluyo.php
 * Springfield
 * Copyright ©: 2022 Integrasoft. Todos los derechos reservados.
 * Desarrollador(es):
 *      L.I. Humberto Javier Flores Tirado
 * Fecha de creación: 29/03/2022.
 * Fecha de modificación: 29/03/2022.
 * Descripción:
 */

namespace app\models\niveleducativo;

use Yii;

/**
 * This is the model class for table "NivelEducativo".
 *
 * @property int $idNivelEducativo
 * @property string $nivelEducativo
 *
 * @property Sustentante[] $sustentantes
 */
class NivelEducativo extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'NivelEducativo';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['nivelEducativo'], 'required'],
            [['nivelEducativo'], 'string', 'max' => 50],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'idNivelEducativo' => 'Id Nivel Educativo',
            'nivelEducativo' => 'Nivel Educativo',
        ];
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getSustentantes()
    {
        return $this->hasMany(Sustentante::className(), ['idNivelEducativo' => 'idNivelEducativo']);
    }
}
