<?php
/*
 * PerfilProfesional.php
 * Springfield
 * Copyright ©: 2022 Integrasoft. Todos los derechos reservados.
 * Desarrollador(es):
 *      I.S.C Julio Alberto Ocampo Rangel
 * Fecha de creación: 27/03/2022.
 * Fecha de modificación: 27/03/2022.
 * Descripción:
 */
namespace app\models\perfilprofesional;

use Yii;
use yii\db\ActiveRecord;
use app\models\areaconocimiento\AreaConocimiento;
use app\models\sustentante\Sustentante;

/**
 * Clase modelo de la tabla "PerfilProfesional".
 *
 * @property int $idPerfilProfesional
 * @property int $idAreaConocimiento
 * @property string $perfilProfesional
 *
 * @property AreaConocimiento $areaConocimiento
 * @property Sustentante[] $sustentantes
 */
class PerfilProfesional extends ActiveRecord
{
    /**
     * Método que devuelve la tabla de la que es modelo la clase.
     */
    public static function tableName()
    {
        return 'PerfilProfesional';
    }

    /**
     * Método que define las validaciones de los atributos.
     */
    public function rules()
    {
        return [
            [['idAreaConocimiento', 'perfilProfesional'], 'required'],
            [['idAreaConocimiento'], 'integer'],
            [['perfilProfesional'], 'string', 'max' => 100],
            [['idAreaConocimiento'], 'exist', 'skipOnError' => true, 'targetClass' => AreaConocimiento::className(), 'targetAttribute' => ['idAreaConocimiento' => 'idAreaConocimiento']],
        ];
    }

    /**
     * Método que define las etiquetas de los atributos.
     */
    public function attributeLabels()
    {
        return [
            'idPerfilProfesional' => 'ID',
            'idAreaConocimiento' => 'ID Area Conocimiento',
            'perfilProfesional' => 'Perfil Profesional',
        ];
    }

    /**
     * @return ActiveQuery
     */
    public function getAreaConocimiento()
    {
        return $this->hasOne(AreaConocimiento::class, ['idAreaConocimiento' => 'idAreaConocimiento']);
    }

    /**
     * @return ActiveQuery
     */
    public function getSustentantes()
    {
        return $this->hasMany(Sustentante::class, ['idPerfilProfesional' => 'idPerfilProfesional']);
    }
}
