<?php
/*
 * Permiso.php
 * Springfield
 * Copyright ©: 2022 Integrasoft. Todos los derechos reservados.
 * Desarrollador(es):
 *      L.I. Humberto Javier Flores Tirado.
 * Fecha de creación: 25/03/2022.
 * Fecha de modificación: 25/03/2022.
 * Descripción:
 */

namespace app\models\permiso;

use Yii;
use yii\db\ActiveRecord;

/**
 * Clase modelo de la tabla "Permiso".
 *
 * @property int $idPermiso
 * @property string $permiso
 *
 * @property RolUsuarioPermiso[] $rolUsuarioPermisos
 */
class Permiso extends ActiveRecord {
    /**
     * Método que devuelve la tabla de la que es modelo la clase.
     */
    public static function tableName() {
        return 'Permiso';
    }

    /**
     * Método que define las validaciones de los atributos.
     */
    public function rules() {
        return [
            [['permiso'], 'string', 'max' => 100],
        ];
    }

    /**
     * Método que define las etiquetas de los atributos.
     */
    public function attributeLabels() {
        return [
            'idPermiso' => 'ID',
            'permiso' => 'Permiso',
        ];
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getRolUsuarioPermisos() {
        return $this->hasMany(RolUsuarioPermiso::className(), ['idPermiso' => 'idPermiso']);
    }
}

?>