<?php
/*
 * RolUsuarioPermioso.php
 * Springfield
 * Copyright ©: 2022 Integrasoft. Todos los derechos reservados.
 * Desarrollador(es):
 *      L.I. Humberto Javier Flores Tirado.
 * Fecha de creación: 25/03/2022.
 * Fecha de modificación: 25/03/2022.
 * Descripción:
 */

namespace app\models\rolusuario;

use Yii;
use yii\db\ActiveRecord;
use yii\db\Expression;
use app\models\sesion\RolUsuario;

/**
 * Clase modelo de la tabla "RolUsuarioPermiso".
 *
 * @property int $idRolUsuarioPermiso
 * @property int $idRolUsuario
 * @property int $idPermiso
 * @property string $createDate
 * @property string $recordDate
 * @property string $deleteDate
 * @property int $idUsuarioCreate
 * @property int $idUsuarioRecord
 * @property int $idUsuarioDelete
 * @property int $idRolUsuarioCreate
 * @property int $idRolUsuarioRecord
 * @property int $idRolUsuarioDelete
 *
 * @property RolUsuario $rolUsuario
 * @property Permiso $permiso
 */
class RolUsuarioPermiso extends ActiveRecord {
    /**
     * Método que devuelve la tabla de la que es modelo la clase.
     */
    public static function tableName() {
        return 'RolUsuarioPermiso';
    }

    /**
     * Método que define las validaciones de los atributos.
     */
    public function rules() {
        return [
            [['idRolUsuario', 'idPermiso', 'createDate', 'recordDate', 'idUsuarioCreate', 'idUsuarioRecord', 'idRolUsuarioCreate', 'idRolUsuarioRecord'], 'required'],
            [['idRolUsuario', 'idPermiso', 'idUsuarioCreate', 'idUsuarioRecord', 'idUsuarioDelete', 'idRolUsuarioCreate', 'idRolUsuarioRecord', 'idRolUsuarioDelete'], 'integer'],
            [['createDate', 'recordDate', 'deleteDate'], 'safe'],
            [['idRolUsuario'], 'exist', 'skipOnError' => true, 'targetClass' => RolUsuario::className(), 'targetAttribute' => ['idRolUsuario' => 'idRolUsuario']],
            [['idPermiso'], 'exist', 'skipOnError' => true, 'targetClass' => Permiso::className(), 'targetAttribute' => ['idPermiso' => 'idPermiso']],
        ];
    }

    /**
     * Método que define las etiquetas de los atributos.
     */
    public function attributeLabels() {
        return [
            'idRolUsuarioPermiso' => 'ID',
            'idRolUsuario' => 'Rol de usuario',
            'idPermiso' => 'Permiso',
            'createDate' => 'Fecha de creación',
            'recordDate' => 'Fecha de modificación',
            'deleteDate' => 'Fecha de eliminación',
        ];
    }

    /**
     * Método que registrar un permiso del rol de usuario.
     *
     * @param $idUsuarioCreate
     * @param $idRolUsuarioCreate
     * @throws \Exception
     */
    public function registrar($idUsuarioCreate, $idRolUsuarioCreate) {
        $this->createDate = new Expression('NOW()');
        $this->recordDate = new Expression('NOW()');
        $this->idUsuarioCreate = $idUsuarioCreate;
        $this->idUsuarioRecord = $idUsuarioCreate;
        $this->idRolUsuarioCreate = $idRolUsuarioCreate;
        $this->idRolUsuarioRecord = $idRolUsuarioCreate;

        if(!$this->save(false)) {
            $error = print_r($this->getErrors(), true);
            throw new \Exception($error);
        }
    }

    /**
     * Método que elimina un permiso del rol de usuario.
     *
     * @throws \Exception
     */
    public function eliminar($idUsuarioDelete, $idRolUsuarioDelete) {
        if(!$this->delete()) {
            $error = print_r($this->getErrors(), true);
            throw new \Exception($error);
        }
    }

    /**
     * Método que elimina todos los permisos de un rol de usuario.
     *
     * @param $idPerfil
     * @param $idUsuarioDelete
     * @param $idRolUsuarioDelete
     */
    public function eliminarXRolUsuario($idRolUsuario, $idUsuarioDelete, $idRolUsuarioDelete) {
        $this->deleteAll(['idRolUsuario' => $idRolUsuario]);
    }

    /**
     * Método que devuelve el rol de usuario.
     *
     * @return \yii\db\ActiveQuery
     */
    public function getRolUsuario() {
        return $this->hasOne(RolUsuario::className(), ['idRolUsuario' => 'idRolUsuario']);
    }

    /**
     * Método que devuelve el permiso.
     *
     * @return \yii\db\ActiveQuery
     */
    public function getPermiso() {
        return $this->hasOne(Permiso::className(), ['idPermiso' => 'idPermiso']);
    }
}

?>