<?php
/*
 * RolUsuarioSearch.php
 * Springfield
 * Copyright ©: 2022 Integrasoft. Todos los derechos reservados.
 * Desarrollador(es):
 *      L.I. Humberto Javier Flores Tirado.
 * Fecha de creación: 25/03/2022.
 * Fecha de modificación: 25/03/2022.
 * Descripción:
 */

namespace app\models\rolusuario;

use Yii;
use yii\base\Model;
use yii\data\ActiveDataProvider;

/**
 * Clase para buscar roles de usuario.
 *
 * Class RolUsuarioSearch
 * @package app\models\rolusuario
 */
class RolUsuarioSearch extends RolUsuario {
    /**
     * Método que define las validaciones de los atributos.
     *
     * @return array
     */
    public function rules() {
        return [
            ['rolUsuario', 'match', 'pattern' => "/^.{3,100}$/", 'message' => 'Se deben ingresar mínimo 3 caracteres'],
            ['createDate', 'date', 'format' => 'php:Y-m-d', 'message' => 'El formato debe ser aaaa-mm-dd'],
            ['recordDate', 'date', 'format' => 'php:Y-m-d', 'message' => 'El formato debe ser aaaa-mm-dd'],
        ];
    }

    /**
     * Método que define los escenarios.
     *
     * @return array
     */
    public function scenarios() {
        return Model::scenarios();
    }

    /**
     * Método para realizar la búsqueda de roles de usuario.
     *
     * @param $params
     * @return ActiveDataProvider
     */
    public function search($params) {
        $query = RolUsuario::find();

        $dataProvider = new ActiveDataProvider
        (
            [
                'query' => $query,
                'sort' => ['defaultOrder' => ['rolUsuario' => SORT_ASC]],
                'pagination' =>
                    [
                        'pageSize' => 50,
                    ],
            ]
        );

        $this->load($params);

        if (!$this->validate()) {
            // uncomment the following line if you do not want to return any records when validation fails
            // $query->where('0=1');
            return $dataProvider;
        }

        $query->andFilterWhere(['LIKE', 'rolUsuario', $this->rolUsuario]);
        $query->andFilterWhere(['=', 'DATE(createDate)', $this->createDate]);
        $query->andFilterWhere(['=', 'DATE(recordDate)', $this->recordDate]);

        return $dataProvider;
    }
}

?>