<?php
/*
 * Sede.php
 * Springfield
 * Copyright ©: 2022 Integrasoft. Todos los derechos reservados.
 * Desarrollador(es):
 *      I.S.C Julio Alberto Ocampo Rangel
 * Fecha de creación: 27/03/2022.
 * Fecha de modificación: 27/03/2022.
 * Descripción:
 */
namespace app\models\sede;

use Yii;
use yii\db\ActiveRecord;
use app\models\estado\Estado;
use app\models\sustentante\Sustentante;

/**
 * Clase modelo de la tabla "Sede".
 *
 * @property int $idSede
 * @property int $idEstado
 * @property string $sede
 * @property string $domicilio
 * @property string $nombreContacto
 * @property string $telefonoContacto
 *
 * @property Estado $estado
 * @property Sustentante[] $sustentantes
 */
class Sede extends ActiveRecord
{
    /**
     * Método que devuelve la tabla de la que es modelo la clase.
     */
    public static function tableName()
    {
        return 'Sede';
    }

    /**
     * Método que define las validaciones de los atributos.
     */
    public function rules()
    {
        return [
            [['idEstado', 'sede', 'domicilio', 'nombreContacto', 'telefonoContacto'], 'required'],
            [['idEstado'], 'integer'],
            [['sede', 'nombreContacto'], 'string', 'max' => 100],
            [['domicilio'], 'string', 'max' => 200],
            [['telefonoContacto'], 'string', 'max' => 10],
            [['idEstado'], 'exist', 'skipOnError' => true, 'targetClass' => Estado::className(), 'targetAttribute' => ['idEstado' => 'idEstado']],
        ];
    }

    /**
     * Método que define las etiquetas de los atributos.
     */
    public function attributeLabels()
    {
        return [
            'idSede' => 'ID',
            'idEstado' => 'ID Estado',
            'sede' => 'Sede',
            'domicilio' => 'Domicilio',
            'nombreContacto' => 'Nombre de contacto',
            'telefonoContacto' => 'Teléfono de contacto',
        ];
    }

    /**
     * @return ActiveQuery
     */
    public function getEstado()
    {
        return $this->hasOne(Estado::class, ['idEstado' => 'idEstado']);
    }

    /**
     * @return ActiveQuery
     */
    public function getSustentantes()
    {
        return $this->hasMany(Sustentante::class, ['idSede' => 'idSede']);
    }
}
