<?php
/*
 * CambiarContraseniaForm.php
 * Springfield
 * Copyright ©: 2022 Integrasoft. Todos los derechos reservados.
 * Desarrollador(es):
 *      L.I. Humberto Javier Flores Tirado.
 * Fecha de creación: 25/03/2022.
 * Fecha de modificación: 25/03/2022.
 * Descripción:
 */

namespace app\models\sesion;

use Yii;
use yii\base\Model;

/**
 * Clase modelo para cambiar contraseña.
 *
 * Class CambiarContraseniaForm
 * @package app\models\sesion
 */
class CambiarContraseniaForm extends Model
{
    public $contrasenia;
    public $confirmaContrasenia;
    public $tokenApp;
    public $idUsuario;

    /**
     * Método que define las validaciones de los atributos.
     *
     * @return array
     */
    public function rules()
    {
        return [
            ['contrasenia','required','message' => 'Es obligatoria'],
            ['contrasenia', 'match', 'pattern' => "/^.{8,50}$/", 'message' => 'Debe tener entre 8 y 50 caracteres'],
            ['contrasenia', 'rulesVerificarContraseniaValida'],
            ['confirmaContrasenia', 'required', 'message' => 'Es obligatoria'],
            ['confirmaContrasenia', 'compare', 'compareAttribute' => 'contrasenia', 'message' => 'No coincide la contraseña y su confirmación'],

            [['tokenApp'], 'safe'],
            [['idUsuario'], 'safe'],
        ];
    }

    /**
     * Método que define las etiquetas de los atributos.
     *
     * @return array
     */
    public function attributeLabels()
    {
        return[
            'contrasenia'=>'Contraseña',
            'confirmaContrasenia'=>'Confirmar contraseña'
        ];
    }

    /**
     * Método para las rules que verifica si la contraseña es válida o no.
     *
     * @param $attribute
     * @param $params
     * @return bool
     */
    public function rulesVerificarContraseniaValida($attribute, $params)
    {
        if(!UsuarioSesion::verificarContraseniaValida($this->contrasenia)) {
            $this->addError($attribute, "La contraseña debe contener por lo menos dos letras, un número y un caracter especial.");
            return true;
        }
        return false;
    }
}

?>