<?php
/*
 * EstatusUsuario.php
 * Springfield
 * Copyright ©: 2022 Integrasoft. Todos los derechos reservados.
 * Desarrollador(es):
 *      L.I. Humberto Javier Flores Tirado.
 * Fecha de creación: 25/03/2022.
 * Fecha de modificación: 25/03/2022.
 * Descripción:
 */

namespace app\models\sesion;

use Yii;
use yii\db\ActiveRecord;

/**
 * Clase modelo de la tabla "EstatusUsuario".
 *
 * @property int $idEstatusUsuario
 * @property string $estatusUsuario
 *
 * @property Administrativo[] $administrativos
 */
class EstatusUsuario extends ActiveRecord
{
    /**
     * Método que devuelve la tabla de la que es modelo la clase.
     */
    public static function tableName()
    {
        return 'EstatusUsuario';
    }

    /**
     * Método que define las validaciones de los atributos.
     */
    public function rules()
    {
        return [
            [['idEstatusUsuario', 'nombre'], 'required'],
            [['idEstatusUsuario'], 'integer'],
            [['estatusUsuario'], 'string', 'max' => 50],
            [['idEstatusUsuario'], 'unique'],
        ];
    }

    /**
     * Método que define las etiquetas de los atributos.
     *
     * @return array
     */
    public function attributeLabels()
    {
        return [
            'idEstatusUsuario' => 'ID',
            'estatusUsuario' => 'Estatus de usuario',
        ];
    }

    /**
     * Método que devuelve los administrativos relacionados a un idEstatusUsuario.
     *
     * @return \yii\db\ActiveQuery
     */
//     public function getAdministrativos()
//     {
//         return $this->hasMany(Administrativo::className(), ['idEstatusUsuario' => 'idEstatusUsuario']);
//     }

    /**
     * Método que devuele todos los estatus de usuario.
     *
     * @return array|\yii\db\ActiveRecord[]
     */
    public static function getTodos()
    {
        return EstatusUsuario::find()->orderBy(['nombre' => SORT_ASC])->all();
    }
}

?>