<?php
/*
 * SesionForm.php
 * Springfield
 * Copyright ©: 2022 Integrasoft. Todos los derechos reservados.
 * Desarrollador(es):
 *      L.I. Humberto Javier Flores Tirado.
 * Fecha de creación: 25/03/2022.
 * Fecha de modificación: 25/03/2022.
 * Descripción:
 */

namespace app\models\sesion;

use Yii;
use yii\base\Model;

/**
 * Clase modelo para manejo de sesión.
 *
 * Class SesionForm
 * @package app\models\sesion
 */
class SesionForm extends Model {
    public $usuario;
    public $contrasenia;
    public $tokenApp;

    /**
     * Método que define las validaciones de los atributos.
     *
     * @return array
     */
    public function rules() {
        return [
            ['usuario', 'required', 'message' => 'Es obligatorio'],
            ['contrasenia', 'required', 'message' => 'Es obligatoria'],

            [['tokenApp'], 'safe'],
        ];
    }

    /**
     * Método que define las etiquetas de los atributos.
     *
     * @return array
     */
    public function attributeLabels() {
        return [
            'usuario' => 'Usuario',
            'contrasenia' => 'Contraseña',
        ];
    }

    /**
     * Método que inicia una sesión de usuario.
     *
     * @throws \Exception
     */
    public function iniciar() {
        $usuarioSesion = UsuarioSesion::getUsuarioSesion($this->usuario, md5($this->contrasenia), null);

        if($usuarioSesion == null)
            throw new \Exception("No existe un usuario con ese usuario y contraseña");

        Yii::$app->user->login($usuarioSesion, 0);
    }

    /**
     * Método que cierra una sesión de usuario.
     */
    public function cerrar() {
        Yii::$app->user->logout();
    }
}

?>