<?php
/*
 * TokenContrasenia.php
 * Springfield
 * Copyright ©: 2022 Integrasoft. Todos los derechos reservados.
 * Desarrollador(es):
 *      L.I. Humberto Javier Flores Tirado.
 * Fecha de creación: 25/03/2022.
 * Fecha de modificación: 25/03/2022.
 * Descripción:
 */

namespace app\models\sesion;

use Yii;
use yii\db\Expression;

/**
 * Clase modelo de la tabla "TokenContrasenia".
 *
 * @property int $idTokenContrasenia
 * @property int $idSesion
 * @property string $token
 * @property string $createDate
 * @property string $recordDate
 * @property string $deleteDate
 * @property int $idUsuarioCreate
 * @property int $idUsuarioRecord
 * @property int $idUsuarioDelete
 * @property int $idRolUsuarioCreate
 * @property int $idRolUsuarioRecord
 * @property int $idRolUsuarioDelete
 */
class TokenContrasenia extends \yii\db\ActiveRecord
{
    /**
     * Método que devuelve la tabla de la que es modelo la clase.
     */
    public static function tableName()
    {
        return 'TokenContrasenia';
    }

    /**
     * Método que define las validaciones de los atributos.
     */
    public function rules()
    {
        return [
            [['idTokenContrasenia', 'idSesion', 'token', 'createDate', 'recordDate', 'idUsuarioCreate', 'idUsuarioRecord', 'idRolUsuarioCreate', 'idRolUsuarioRecord'], 'required'],
            [['idTokenContrasenia', 'idSesion', 'idUsuarioCreate', 'idUsuarioRecord', 'idUsuarioDelete', 'idRolUsuarioCreate', 'idRolUsuarioRecord', 'idRolUsuarioDelete'], 'integer'],
            [['createDate', 'recordDate', 'deleteDate'], 'safe'],
            [['token'], 'string', 'max' => 50],
            [['idTokenContrasenia'], 'unique'],
        ];
    }

    /**
     * Método que define las etiquetas de los atributos.
     */
    public function attributeLabels()
    {
        return [
            'idTokenContrasenia' => 'ID',
            'idSesion' => 'Sesión',
            'token' => 'Token',
            'createDate' => 'Fecha de creación',
            'recordDate' => 'Fecha de modificación',
            'deleteDate' => 'Fecha de eliminación',
        ];
    }

    /**
     * Método que registrar un TokenContrasenia.
     *
     * @param $idSesion
     * @param $idRolUsuarioCreate
     * @throws \Exception
     */
    public function registrar($idUsuarioCreate, $idRolUsuarioCreate)
    {
        $this->createDate = new Expression('NOW()');
        $this->recordDate = new Expression('NOW()');
        $this->idUsuarioCreate = $idUsuarioCreate;
        $this->idUsuarioRecord = $idUsuarioCreate;
        $this->idRolUsuarioCreate = $idRolUsuarioCreate;
        $this->idRolUsuarioRecord = $idRolUsuarioCreate;

        if(!$this->save(false))
        {
            $error = print_r($this->getErrors(), true);
            throw new \Exception($error);
        }
    }

    /**
     * Método que elimina un TokenContrasenia.
     *
     * @throws \Exception
     */
    public function eliminar($idUsuarioDelete, $idRolUsuarioDelete)
    {
        if(!$this->delete())
        {
            $error = print_r($this->getErrors(), true);
            throw new \Exception($error);
        }
    }

    /**
     * Método que genera el token aleatorio para poder recuperar una contraseña.
     */
    public function generar()
    {
        $this->token = static::generarToken();
    }

    /**
     * Método que genera el token aleatorio para poder recuperar una contraseña.
     *
     * @return mixed
     */
    public static function generarToken()
    {
        return md5(microtime(true));
    }

    /**
     * Método que devuelve el objeto del token.
     *
     * @param $token
     * @return null|static
     */
    public static function getXToken($token)
    {
        return TokenContrasenia::findOne(['token' => $token]);
    }
}

?>
