<?php
/*
 * UsuarioSesion.php
 * Springfield
 * Copyright ©: 2022 Integrasoft. Todos los derechos reservados.
 * Desarrollador(es):
 *      L.I. Humberto Javier Flores Tirado.
 * Fecha de creación: 25/03/2022.
 * Fecha de modificación: 28/03/2022.
 * Descripción:
 */

namespace app\models\sesion;

use Yii;
use yii\web\IdentityInterface;
use app\models\usuario\Usuario;
use app\models\sesion\TokenContrasenia;

/**
 * Clase modelo "UsuarioSesion".
 *
 * @property int $id
 * @property int $idUsuario
 * @property Usuario $datos
 * @property string $usuario;
 * @property string $contrasenia;
 * @property string $nombre;
 * @property string $primerApellido;
 * @property string $segundoApellido;
 * @property RolUsuario $rolUsuario
 * @property EstatusUsuario $estatusUsuario
 * @property TokenContrasenia[] $tokenContrasenia
 */
class UsuarioSesion implements IdentityInterface {
    public $id;
    public $idUsuario;
    public $idRolUsuario;
    public $usuario;
    public $contrasenia;
    public $nombre;
    public $primerApellido;
    public $segundoApellido;
    public $rolUsuario;
    public $estatusUsuario;
    public $tokenContrasenia;

    /**
     * Método que devuelve el UsuarioSesion por su identificador conformado por el usuario y la contraseña.
     *
     * @param int|string $id
     * @return UsuarioSesion|null
     */
    public static function findIdentity($id) {
        return static::getUsuarioSesion(null, null, $id);
    }

    /**
     * @inheritdoc
     */
    public static function findIdentityByAccessToken($token, $type = null) {}

    /**
     * @inheritdoc
     */
    public function getId() {
        return $this->id;
    }

    /**
     * @inheritdoc
     */
    public function getAuthKey() {}

    /**
     * @inheritdoc
     */
    public function validateAuthKey($authKey) {}

    /**
     * Método que permite cambiar la contraseña de un usuario.
     */
    public function cambiarContrasenia($contrasenia, $idUsuarioRecord, $idRolUsuarioRecord) {
        $this->datos->cambiarContrasenia($contrasenia, $idUsuarioRecord, $idRolUsuarioRecord);
    }

    /**
     * Método que permite recuperar la contraseña de un usuario.
     *
     * @param $correoElectronico
     * @return bool
     * @throws \Exception
     */
    public static function recuperarContrasenia($correoElectronico) {
        $usuarioSesion = static::getUsuarioSesion($correoElectronico, null, null);
        $token = null;
        if($usuarioSesion != null) {
            $tokenGenerado = TokenContrasenia::find()->where(['idSesion' => $usuarioSesion->id])->one();

            if($tokenGenerado == null) {
                $tokenGenerado = new TokenContrasenia();
                $tokenGenerado->idSesion = $usuarioSesion->id;
                $tokenGenerado->generar();
                $tokenGenerado->registrar($usuarioSesion->idUsuario, $usuarioSesion->rolUsuario->idRolUsuario);
                $token = $tokenGenerado->token;
            } else {
                $token = $tokenGenerado->token;
            }

            $mensaje = "Se ha creado un enlace para recuperar la contraseña. Por favor presiona " .
                "<a href='" . Yii::$app->params['url'] .
                "/sesion/recuperar-contrasenia-token?token=" . $token . "'>AQUÍ</a>.";

            Yii::$app->mailer->compose()
                ->setTo($correoElectronico)
                ->setFrom(Yii::$app->params['no-reply'])
                ->setSubject(Yii::$app->params['asuntoRecuperarContrasenia'])
                ->setHtmlBody($mensaje)
                ->send();

            return true;

        }

        return false;
    }

    /**
     * Método que devuelve un UsuarioSesion por su usuario y contraseña.
     *
     * @param $usuario
     * @param $contrasenia
     * @param $idSesion
     * @return UsuarioSesion|null
     */
    public static function getUsuarioSesion($usuario = null, $contrasenia = null, $idSesion = null) {
        $usuarioSesion = null;
        $datos = null;

        if($usuario != "" && $contrasenia != "") {
            $usuario = Usuario::find()->where(['usuario' => $usuario, 'contrasenia' => $contrasenia,
                'idEstatusUsuario' => 1])->one();
        }
        elseif($idSesion != "") {
            $usuario = Usuario::find()->where(['idSesion' => $idSesion,
                'idEstatusUsuario' => 1])->one();
        } elseif($usuario != "") {
            $usuario = Usuario::find()->where(['usuario' => $usuario,
                'idEstatusUsuario' => 1])->one();
        }

        if($usuario == null)
            return null;

        $usuarioSesion = new UsuarioSesion();

        if($usuario != null) {
            $usuarioSesion->datos = $usuario;
            $usuarioSesion->id = $usuario->idSesion;
            $usuarioSesion->idUsuario = $usuario->idUsuario;
            $usuarioSesion->idRolUsuario = $usuario->idRolUsuario;
            $usuarioSesion->usuario = $usuario->usuario;
            $usuarioSesion->contrasenia = $usuario->contrasenia;
            $usuarioSesion->nombre = $usuario->nombre;
            $usuarioSesion->primerApellido = $usuario->primerApellido;
            $usuarioSesion->segundoApellido = $usuario->segundoApellido;
            $usuarioSesion->rolUsuario = $usuario->rolUsuario;
            $usuarioSesion->estatusUsuario = $usuario->estatusUsuario;
        }

        return $usuarioSesion;
    }

    /**
     * Método que verifica si una contraseña tiene el formato válido o no.
     *
     * @param $contrasenia
     * @return bool
     */
    public static function verificarContraseniaValida($contrasenia) {
        $coincidencias = null;
        $expresion = "/(?=(.*[a-zA-Z]){2})/";
        preg_match($expresion, $contrasenia, $coincidencias);

        if(sizeof($coincidencias) <= 0)
            return false;

        $coincidencias = null;
        $expresion = "/(?=(.*[0-9]){1})/";
        preg_match($expresion, $contrasenia, $coincidencias);

        if(sizeof($coincidencias) <= 0)
            return false;

        $coincidencias = null;
        $expresion = "/(?=(.*\W){1})/";
        preg_match($expresion, $contrasenia, $coincidencias);

        if(sizeof($coincidencias) <= 0)
            return false;

        $coincidencias = null;
        $expresion = "/[\s]/";
        preg_match($expresion, $contrasenia, $coincidencias);

        if(sizeof($coincidencias) > 0)
            return false;

        return true;
    }

    /**
     * Método que verifica si existe un usuario de acuerdo a los parámetros proporcionados.
     *
     * @param $usuario
     * @param null $idUsuario
     * @return bool
     */
    public static function verificarExistencia($usuario, $idUsuario = null) {
        if(Usuario::verificarExistencia($usuario, $idUsuario))
            return true;

        return false;
    }
}

?>