<?php
/*
 * VerificarSesionForm.php
 * Springfield
 * Copyright ©: 2022 Integrasoft. Todos los derechos reservados.
 * Desarrollador(es):
 *      L.I. Humberto Javier Flores Tirado.
 * Fecha de creación: 25/03/2022.
 * Fecha de modificación: 25/03/2022.
 * Descripción:
 */

namespace app\models\sesion;

use Yii;
use yii\base\Model;

use app\models\usuario\Usuario;

/**
 * Clase modelo para vertificar sesión.
 *
 * Class VerificarSesionForm
 * @package app\models\sesion
 */
class VerificarSesionForm extends Model
{
    public $idUsuario;
    public $tokenApp;

    /**
     * Método que define las validaciones de los atributos.
     *
     * @return array
     */
    public function rules()
    {
        return [
            ['idUsuario', 'required', 'message' => 'Es obligatorio'],
            [['tokenApp'], 'safe'],
        ];
    }

    /**
     * Método que define las etiquetas de los atributos.
     *
     * @return array
     */
    public function attributeLabels()
    {
        return [
            'idUsuario' => 'Usuario',
        ];
    }

    /**
     * Método que verifica el estátus de usuario.
     *
     * @throws \Exception
     */
    public function verificarSesion()
    {
        $usuario = Usuario::findOne($this->idUsuario);

        if($usuario == null)
            throw new \Exception("No existe un usuario con ese ID");

        if($usuario->idEstatusUsuario > 1)
            throw new \Exception("El usuario ha sido desactivado");

        return true;
    }
}

?>
