<?php
/*
 * Sexo.php
 * Springfield
 * Copyright ©: 2022 Integrasoft. Todos los derechos reservados.
 * Desarrollador(es):
 *      I.S.C Julio Alberto Ocampo Rangel
 * Fecha de creación: 27/03/2022.
 * Fecha de modificación: 27/03/2022.
 * Descripción:
 */
namespace app\models\sexo;

use Yii;
use yii\db\ActiveRecord;
use app\models\sustentante\Sustentante;

/**
 * Clase modelo de la tabla "Sexo".
 *
 * @property int $idSexo
 * @property string $sexo
 *
 * @property Sustentante[] $sustentantes
 */
class Sexo extends ActiveRecord
{
    /**
     * Método que devuelve la tabla de la que es modelo la clase.
     */
    public static function tableName()
    {
        return 'Sexo';
    }

    /**
     * Método que define las validaciones de los atributos.
     */
    public function rules()
    {
        return [
            [['sexo'], 'required'],
            [['sexo'], 'string', 'max' => 50],
        ];
    }

    /**
     * Método que define las etiquetas de los atributos.
     */
    public function attributeLabels()
    {
        return [
            'idSexo' => 'ID',
            'sexo' => 'Sexo',
        ];
    }

    /**
     * @return ActiveQuery
     */
    public function getSustentantes()
    {
        return $this->hasMany(Sustentante::class, ['idSexo' => 'idSexo']);
    }
}
