<?php
/*
 * SustentanteSearch.php
 * Springfield
 * Copyright ©: 2022 Integrasoft. Todos los derechos reservados.
 * Desarrollador(es):
 *      I.S.C Julio Alberto Ocampo Rangel.
 *      L.I. Humberto Javier Flores Tirado.
 * Fecha de creación: 28/03/2022.
 * Fecha de modificación: 19/05/2022.
 * Descripción:
 */
namespace app\models\sustentante;

use app\models\sustentante\Sustentante;
use Yii;
use yii\base\Model;
use yii\data\ActiveDataProvider;

/**
 * Clase para buscar sustentantes.
 *
 * Class SustentanteSearch
 * @package app\models\sustentante
 */
class SustentanteSearch extends Sustentante {
    /**
     * Método que define las validaciones de los atributos.
     *
     * @return array
     */
    public function rules() {
        return [
            [['numeroControl','nacionalidad','lugarNacimiento','colonia','archivoPersonaAutorizada1'],
                'match', 'pattern' => "/^.{3,50}$/", 
                'message' => 'Se deben ingresar mínimo 3 caracteres'],
            [['calleNumero','municipio','institucion','licenciatura','personaAutorizada1','personaAutorizada2',
                'archivoPersonaAutorizada2','archivoActaNacimiento','archivoCurp','archivoIne',
                'archivoCertificado','archivoAntecedenteSecundaria','archivoCurriculum','archivoDoctoUltimoGradoEstudios'], 
                'match', 'pattern' => "/^.{3,100}$/", 
                'message' => 'Se deben ingresar mínimo 3 caracteres'],
            ['curp',
                'match', 'pattern' => "/^.{18}$/", 
                'message' => 'Se deben ingresar 18 caracteres'],
            ['codigoPostal',
                'match', 'pattern' => "/^.{5}$/", 
                'message' => 'Se deben ingresar 5 caracteres'],
            [['telefonoCasa', 'telefonoOficina', 'celular'],
                'match', 'pattern' => "/^.{10}$/", 
                'message' => 'Se deben ingresar 10 caracteres'],
            [['nombre'], 'safe'],
            [['primerApellido'], 'safe'],
            [['segundoApellido'], 'safe'],
            [['idSede'], 'safe'],
            [['idSexo'], 'safe'],
            [['idEstado'], 'safe'],
            [['idNivelEducativo'], 'safe'],
            [['idAreaConocimiento'], 'safe'],
            [['idPerfilProfesional'], 'safe'],
            [['idMotivoNoConcluyo'], 'safe'],
            [['idAntecedenteAcademico'], 'safe'],
            [['idEstatusSustentante'], 'safe'],
            ['createDate', 'date', 'format' => 'php:Y-m-d', 'message' => 'El formato debe ser aaaa-mm-dd'],
            ['recordDate', 'date', 'format' => 'php:Y-m-d', 'message' => 'El formato debe ser aaaa-mm-dd'],
        ];
    }

    /**
     * Método que define los escenarios.
     *
     * @return array
     */
    public function scenarios() {
        return Model::scenarios();
    }

    /**
     * Método para realizar la búsqueda de roles de usuario.
     *
     * @param $params
     * @return ActiveDataProvider
     */
    public function search($params) {
        $query = Sustentante::find()->alias('US');
        $query -> innerJoin("Usuario U", "U.idUsuario=US.idUsuario");
        $query -> leftJoin("PerfilProfesional PF", "PF.idPerfilProfesional=US.idPerfilProfesional");

        $dataProvider = new ActiveDataProvider
        (
            [
                'query' => $query,
                'sort' => ['defaultOrder' => ['idSustentante' => SORT_ASC]],
                'pagination' =>
                    [
                        'pageSize' => 50,
                    ],
            ]
        ); 

        $this->load($params);

        if (!$this->validate()) {
            // uncomment the following line if you do not want to return any records when validation fails
            // $query->where('0=1');
            return $dataProvider;
        }

        $query->andFilterWhere(['=', 'U.idSede', $this->idSede]);
        $query->andFilterWhere(['=', 'US.idSexo', $this->idSexo]);
        $query->andFilterWhere(['=', 'US.idEstado', $this->idEstado]);
        $query->andFilterWhere(['=', 'US.idNivelEducativo', $this->idNivelEducativo]);
        $query->andFilterWhere(['=', 'US.idPerfilProfesional', $this->idPerfilProfesional]);
        $query->andFilterWhere(['=', 'PF.idAreaConocimiento', $this->idAreaConocimiento]);
        $query->andFilterWhere(['=', 'US.idMotivoNoConcluyo', $this->idMotivoNoConcluyo]);
        $query->andFilterWhere(['=', 'US.idAntecedenteAcademico', $this->idAntecedenteAcademico]);
        $query->andFilterWhere(['=', 'US.idEstatusSustentante', $this->idEstatusSustentante]);
        $query->andFilterWhere(['LIKE', 'U.nombre', $this->nombre]);
        $query->andFilterWhere(['LIKE', 'U.primerApellido', $this->primerApellido]);
        $query->andFilterWhere(['LIKE', 'U.segundoApellido', $this->segundoApellido]);
        $query->andFilterWhere(['LIKE', 'US.numeroControl', $this->numeroControl]);
        $query->andFilterWhere(['LIKE', 'US.curp', $this->curp]);
        $query->andFilterWhere(['=', 'DATE(US.createDate)', $this->createDate]);
        $query->andFilterWhere(['=', 'DATE(US.recordDate)', $this->recordDate]);

        //echo $query->createCommand()->getRawSql();
        //exit;
        

        return $dataProvider;
    }
}

?>