<?php
/*
 * UsuarioSearch.php
 * Springfield
 * Copyright ©: 2022 Integrasoft. Todos los derechos reservados.
 * Desarrollador(es):
 *      L.I. Humberto Javier Flores Tirado.
 * Fecha de creación: 25/03/2022.
 * Fecha de modificación: 17/05/2022.
 * Descripción:
 */

namespace app\models\usuario;

use Yii;
use yii\base\Model;
use yii\data\ActiveDataProvider;

class UsuarioSearch extends Usuario {

    public $idTipoUsuario;
    
        public function rules() {
            return [
                ['usuario', 'match', 'pattern' => "/^.{3,100}$/", 'message' => 'Se deben ingresar mínimo 3 caracteres'],
                ['nombre', 'match', 'pattern' => "/^.{3,100}$/", 'message' => 'Se deben ingresar mínimo 3 caracteres'],
                ['primerApellido', 'match', 'pattern' => "/^.{3,100}$/", 'message' => 'Se deben ingresar mínimo 3 caracteres'],
                ['segundoApellido', 'match', 'pattern' => "/^.{3,100}$/", 'message' => 'Se deben ingresar mínimo 3 caracteres'],
                [['idEstado'], 'safe'],
                [['idSede'], 'safe'],
                [['idRolUsuario'], 'safe'],
                [['idEstatusUsuario'], 'safe'],
                ['createDate', 'date', 'format' => 'php:Y-m-d', 'message' => 'El formato debe ser aaaa-mm-dd'],
                ['recordDate', 'date', 'format' => 'php:Y-m-d', 'message' => 'El formato debe ser aaaa-mm-dd'],
            ];
        }
        
        public function scenarios() {
            return Model::scenarios();
        }
        
        public function search($params) {
            $query = Usuario::find();
           // $query -> leftJoin("region R", "R.idRegion=usuario.idRegion");
            //$query -> leftJoin("Estado E", "E.idEstado=.idEstado");

            $dataProvider = new ActiveDataProvider
            (
                [
                    'query' => $query,
                    'sort' => ['defaultOrder' => ['nombre' => SORT_ASC]],
                    'pagination' =>
                        [
                            'pageSize' => 50,
                        ],
                ]
            );
            
            $this->load($params);
            
            if (!$this->validate()) {
                // uncomment the following line if you do not want to return any records when validation fails
                // $query->where('0=1');
                return $dataProvider;
            }

            $query->andWhere(['!=', 'idRolUsuario', 2]);
            $query->andWhere(['!=', 'idUsuario', $this->idUsuario]);
            //$query->andFilterWhere(['!=', 'idUsuario', $this->idUsuario]);
            $query->andFilterWhere(['=', 'idRolUsuario', $this->idRolUsuario]);
            $query->andFilterWhere(['=', 'idEstatusUsuario', $this->idEstatusUsuario]);
            $query->andFilterWhere(['=', 'idEstado', $this->idEstado]);
            $query->andFilterWhere(['=', 'idSede', $this->idSede]);
            $query->andFilterWhere(['LIKE', 'usuario', $this->usuario]);
            $query->andFilterWhere(['LIKE', 'nombre', $this->nombre]);
            $query->andFilterWhere(['LIKE', 'primerApellido', $this->primerApellido]);
            $query->andFilterWhere(['LIKE', 'segundoApellido', $this->segundoApellido]);
            $query->andFilterWhere(['=', 'DATE(createDate)', $this->createDate]);
            $query->andFilterWhere(['=', 'DATE(recordDate)', $this->recordDate]);
            
            return $dataProvider;
        }
}
?>
