<?php
/*
 * JsonResponse.php
 * CGVE
 * Copyright ©: 2020 Integrasoft. Todos los derechos reservados.
 * Desarrollador(es):
 *      José Adrián Mayorga Silva
 * Fecha de creación: 07/09/2020.
 * Fecha de modificación: 07/09/2020.
 * Descripción:
 */

namespace app\models\util;

use Yii;
use yii\base\Model;

/**
 * Clase modelo para manejo de json response.
 *
 * Class JsonResponse
 * @package app\models\salidafija
 */
class JsonResponse extends Model
{
    public $jsonEstatus;
    public $jsonMensaje;
    public $jsonDatos;
    
    /**
     * Método que define las validaciones de los atributos.
     *
     * @return array
     */
    public function rules()
    {
        return [
            [['jsonEstatus', 'jsonMensaje', 'jsonDatos'], 'safe']
        ];
    }
    
    /**
     * Método que define las etiquetas de los atributos.
     *
     * @return array
     */
    public function attributeLabels()
    {
        return [
            'jsonEstatus' => 'estatus',
            'jsonMensaje' => 'mensaje',
            'jsonDatos' => 'datos'
        ];
    }
    
}
?>