<?php
/*
 * Utils.php
 * ABM
 * Copyright ©: 2018 Integrasoft. Todos los derechos reservados.
 * Desarrollador(es):
 *      L.I. Humberto Javier Flores Tirado.
 * Fecha de creación: 17/09/2018.
 * Fecha de modificación: 28/06/2019.
 * Descripción:
 */

namespace app\models\util;

class Utils {
    /**
     * Método que verifica si un RFC es válido o no.
     *
     * @param $rfc
     * @return bool
     */
    public static function verificarRFCValido($rfc) {
        $expresion = "/^([A-Z,Ñ,&]{3,4}([0-9]{2})(0[1-9]|1[0-2])(0[1-9]|1[0-9]|2[0-9]|3[0-1])[A-Z|\d]{3})$/";
        return preg_match($expresion, $rfc);
    }

    /**
     * Método que compara las fechas donde devuelve:
     * -1 si $fecha1 es menor a $fecha2
     * 0 si $fecha1 y $fecha2 son iguales
     * 1 si $fecha1 es mayor a $fecha2
     *
     * @param $fecha1
     * @param $fecha2
     * @return int
     */
    public static function compararFechas($fecha1, $fecha2) {
        if(strtotime($fecha1) < strtotime($fecha2))
            return -1;
        elseif(strtotime($fecha1) == strtotime($fecha2))
            return 0;
        else
            return 1;
    }

    public static function descargarArchivo($rutaArchivo, $nombreArchivo = null) {
        if($nombreArchivo == null)
            $nombreArchivo = $rutaArchivo;

        if(file_exists($rutaArchivo)) {
            header('Content-Description: File Transfer');
            header('Content-Type: application/octet-stream');
            header('Content-Disposition: attachment; filename="'.basename($nombreArchivo).'"');
            header('Cache-Control: no-cache');
            header('Pragma: no-cache');
            header('Content-Length: ' . filesize($rutaArchivo));
            flush();
            readfile($rutaArchivo);
            exit;
        } else {
            throw new \Exception("No existe el archivo");
        }
    }
    
    public static function visualizarArchivo($rutaArchivo, $nombreArchivo = null) {
        if($nombreArchivo == null)
            $nombreArchivo = $rutaArchivo;
            
            $contentType = mime_content_type($rutaArchivo);
            
            if(file_exists($rutaArchivo)) {
                header('Content-Description: File Transfer');
                header('Content-Type: ' . $contentType);
                header('Content-Disposition: inline; filename="'.basename($nombreArchivo).'"');
                header('Cache-Control: no-cache');
                header('Pragma: no-cache');
                header('Content-Length: ' . filesize($rutaArchivo));
                flush();
                readfile($rutaArchivo);
                exit;
            } else {
                throw new \Exception("No existe el archivo");
            }
    }
    
    
    
}

?>