/*
 * registrar.js
 * Springfield
 * Copyright ©: 2022 Integrasoft. Todos los derechos reservados.
 * Desarrollador(es):
 *      I.S.C Julio Alberto Ocampo Rangel.
 *      L.I. Humberto Javier Flores Tirado.
 * Fecha de creación: 29/03/2022.
 * Fecha de modificación: 29/03/2022.
 * Descripción:
 */

/**
 * Método que devuelve a través de ajax, los perfiles profesionales por área de conocimiento.
 * @param idAreaConocimiento
 */
$(function(){
    $("#sustentante-idareaconocimiento").attr('disabled', true);
    $("#sustentante-idperfilprofesional").attr('disabled', true);
    $("#sustentante-institucion").attr('disabled', true);
    $("#sustentante-porcentajecreditoscursados").attr('disabled', true);

    $("#sustentante-archivoantecedentesecundaria").attr('disabled', true);
    $("#sustentante-archivocurriculum").attr('disabled', true);
    $("#sustentante-archivodoctoultimogradoestudios").attr('disabled', true);

    $("#sustentante-idniveleducativo").change(function(){
        switch($(this).val()){
            case "0":
                $("#sustentante-idareaconocimiento > option[value='']").prop('selected', true);
                $("#sustentante-idperfilprofesional > option[value='']").prop('selected', true);
                $("#sustentante-institucion").val('');
                $("#sustentante-porcentajecreditoscursados").val('');

                $("#sustentante-idareaconocimiento").attr('disabled', true);
                $("#sustentante-idperfilprofesional").attr('disabled', true);
                $("#sustentante-institucion").attr('disabled', true);
                $("#sustentante-porcentajecreditoscursados").attr('disabled', true);
                $("#sustentante-archivoantecedentesecundaria").attr('disabled', true);
                $("#sustentante-archivocurriculum").attr('disabled', true);
                $("#sustentante-archivodoctoultimogradoestudios").attr('disabled', true);
                break;
            case "1":
                $("#sustentante-idareaconocimiento > option[value='']").prop('selected', true);
                $("#sustentante-idperfilprofesional > option[value='']").prop('selected', true);
                $("#sustentante-institucion").val('');
                $("#sustentante-porcentajecreditoscursados").val('');

                $("#sustentante-idareaconocimiento").attr('disabled', true);
                $("#sustentante-idperfilprofesional").attr('disabled', true);
                $("#sustentante-institucion").attr('disabled', true);
                $("#sustentante-porcentajecreditoscursados").attr('disabled', true);
                $("#sustentante-archivoantecedentesecundaria").attr('disabled', false);
                $("#sustentante-archivocurriculum").attr('disabled', true);
                $("#sustentante-archivodoctoultimogradoestudios").attr('disabled', true);
                break;
            case "2":
                $("#sustentante-idareaconocimiento").attr('disabled', false);
                $("#sustentante-idperfilprofesional").attr('disabled', false);
                $("#sustentante-institucion").attr('disabled', false);
                $("#sustentante-porcentajecreditoscursados").attr('disabled', false);
                $("#sustentante-archivoantecedentesecundaria").attr('disabled', true);
                $("#sustentante-archivocurriculum").attr('disabled', false);
                $("#sustentante-archivodoctoultimogradoestudios").attr('disabled', false);
                
                break;
        }
    });

    $("#sustentante-idareaconocimiento").change(function() {
        var idAreaConocimiento = $(this).val();
        if(idAreaConocimiento > 0)
        {
            $('#sustentante-idperfilprofesional option').remove();
            $('#sustentante-idperfilprofesional').append('<option value="" selected>Selecciona una opción...</option>');
            $.ajax({
                mimeType: 'text/html; charset=utf-8',
                cache: false,
                method: 'POST',
                dataType: 'json',
                url: $('#ruta-web-app').text() + '/sustentante/json-perfiles-profesionales-x-area-conocimiento',
                data: {
                    idAreaConocimiento: idAreaConocimiento
                },
                error: function(xhr, textStatus, errorThrown)
                {
                    alert("Ocurrió un error inesperado, por favor intenta nuevamente");
                },
                success: function(response, textStatus, xhr)
                {
                    if(response.estatus == "ok")
                    {
                        $.each(response.datos, function(contador, item) {
                            $('#sustentante-idperfilprofesional').append('<option value="' + item['idPerfilProfesional'] + '">' + item['perfilProfesional'] + '</option>');
                        });
                    }
                    else
                    {
                        alert(response.mensaje);
                    }
                }
            });
        }
        else
        {
            $('#sustentante-idperfilprofesional option').remove();
            $('#sustentante-idperfilprofesional').append('<option value="" selected>Selecciona una opción...</option>');
        }
    });  
    
    $("#sustentante-idniveleducativo").trigger('change');
})
