<?php
/*
 * dashboard-color-admin.php
 * CGVE
 * Copyright ©: 2020 Integrasoft. Todos los derechos reservados.
 * Desarrollador(es):
 *      L.I. Humberto Javier Flores Tirado.
 *      I.S.C. Julio Alberto Ocampo Rangel.
 * Fecha de creación: 15/07/2020.
 * Fecha de modificación: 31/08/2020.
 * Descripción:
 */

use app\widgets\Alert;
use yii\helpers\Html;
use yii\bootstrap\Nav;
use yii\bootstrap\NavBar;
use yii\widgets\Breadcrumbs;
use app\assets\DashboardColorAdminAppAsset;

DashboardColorAdminAppAsset::register($this);

if(isset(Yii::$app->user->identity)) {
    $idUsuario = Yii::$app->user->identity->idUsuario;
    $idRolUsuario = Yii::$app->user->identity->rolUsuario->idRolUsuario;
    $idTipoUsuario = Yii::$app->user->identity->datos->tipoUsuario->idTipoUsuario;
    $nombreTipoUsuario = Yii::$app->user->identity->datos->tipoUsuario->tipoUsuario;
} else {
    $idUsuario = null;
    $idRolUsuario = null;
    $idTipoUsuario = null;
    $nombreTipoUsuario = "Anónimo";
}

?>

<?php $this->beginPage() ?>
<!DOCTYPE html>
<html lang="<?= Yii::$app->language ?>">
<head>
    <meta charset="<?= Yii::$app->charset ?>">
    <meta content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no" name="viewport" />
    <meta content="" name="description" />
    <meta content="" name="author" />
    <?= Html::csrfMetaTags() ?>
    <title><?= Html::encode($this->title) ?></title>
    <?php $this->head() ?>
    <style>
        
        .dropdown-menu {
            font-size: 12px;
            border: none;
            box-shadow: 0 2px 2px rgba(0,0,0,.15);
        }
        
        .dropdown-menu {
            position: absolute;
            top: 100%;
            left: 0;
            z-index: 1000;
            display: none;
            float: left;
            min-width: 10rem;
            padding: .5rem 0;
            margin: .125rem 0 0;
            font-size: 1rem;
            color: #212529;
            text-align: left;
            list-style: none;
            background-color: #fff;
            background-clip: padding-box;
            border: 1px solid rgba(0,0,0,.15);
            border-radius: .25rem;
        }
        
       
        .dropdown-menu.dropdown-menu-cart {
            margin-right: 0;
            width: 320px;
            margin-top: 10px;
        }
        
        .dropdown-menu.dropdown-menu-cart {
            left: auto;
            right: 0;
            margin-right: -142px;
            width: 360px;
        }
        
        .p-0 {
            padding: 0!important;
        }
        
        .header-cart .total, .step.active .number:before {
            background: #00acac;
        }
        
        .header-cart .total {
            font-size: 12px;
            color: #fff;
            font-weight: 700;
            background: #00acac;
            display: inline-block;
            width: 20px;
            height: 20px;
            line-height: 20px;
            text-align: center;
            border-radius: 20px;
         }
                
         .cart-body+.cart-footer, .cart-header+.cart-body, .cart-item>li+li {
             border-top: 1px solid #e5e5e5;
             display: block; 
         }
        
         .cart-body, .cart-footer, .cart-header {
             padding: 15px;
             display: block;  
         }

         .cart-footer {
            display: none; 
         }
 
         .fa-shopping-bag:active ~ .cart-footer {
            display: block; 
         }
 
         .cart-title {
             font-size: 12px;
             font-weight: 700;
             margin: 0;
         }
         
         .cart-item {
             list-style-type: none;
             margin: 0;
             padding: 0;
         }
         
         .cart-item>li+li {
            padding-top: 10px;
            margin-top: 10px;
         }
         
         .cart-item>li {
            display: table;
            width: 100%;
         }
        
         .cart-item-image+.cart-item-info, .cart-item-info+.cart-item-close {
             padding-left: 15px;
         }
        
          .cart-item>li>div {
             display: table-cell;
             vertical-align: middle;
         }
        
         .cart-item-info {
             width: 80%;
         }
        
         .cart-item > li .price, .header-logo a span, a {
             color: #00acac;
         }
        
         .cart-item>li h4 {
             font-size: 14px;
             line-height: 18px;
             margin: 3px 0;
         }
        
         .cart-item-image img {
             max-height: 100%;
         }
        
         .cart-item-image {
             float: left;
             width: 80px;
             height: 60px;
             padding: 7px;
             overflow: hidden;
             text-align: center;
             line-height: 44px;
             border: 1px solid #e5e5e5;
         }
         
         
         .cart-item-close a {
            font-size: 18px;
            color: #999;
            height: 24px;
            width: 24px;
            text-align: center;
            line-height: 24px;
            display: block;
            text-decoration: none;
            border-radius: 24px;
            background: #f9f9f9;
        }


   
    </style>
    <script type="text/javascript">


       /* $('.dropdown-hover').click(function(){
            alert('');
        }); */

       /* .cart-footer {
            display: none; 
         } */


    </script>
</head>
<body>
<?php $this->beginBody() ?>

<?// $content ?>


<!-- begin #page-loader -->
<div id="page-loader" class="fade show"><span class="spinner"></span></div>
<!-- end #page-loader -->

<!-- begin #page-container -->
<div id="page-container" class="fade page-sidebar-fixed page-header-fixed">
    <!-- begin #header -->
    <div id="header" class="header navbar-default">
        <!-- begin navbar-header -->
        <div class="navbar-header">

			<?= Html::a(Html::img(Yii::getAlias('@web').'/images/logos/logo_clubvalle_escondido.png', ['alt'=>'media-object']), ['/sesion/']) ?>
<!--             <a href="index.html" class="navbar-brand"><span class="navbar-logo"></span> <b>Color</b> Admin</a> -->
            <button type="button" class="navbar-toggle" data-click="sidebar-toggled">
                <span class="icon-bar"></span>
                <span class="icon-bar"></span>
                <span class="icon-bar"></span>
            </button>
            
        </div>
        <!-- end navbar-header -->
        
        <!-- begin header-nav -->
        <ul class="navbar-nav navbar-right">
        	<li class="dropdown navbar-user">
                <a href="#" class="dropdown-toggle" data-toggle="dropdown">
                    <img src="<?= Yii::getAlias('@web') ?>/images/foto_base.jpg" alt="" />
                    <span class="d-none d-md-inline"><?= $nombreTipoUsuario ?></span> <b class="caret"></b>
                </a>
                <div class="dropdown-menu dropdown-menu-right">
                    <a href="<?= Yii::getAlias('@web') ?>/usuario/actualizar-datos/" class="dropdown-item">Actualizar</a>
                    <a href="<?= Yii::getAlias('@web') ?>/sesion/cambiar-contrasenia/" class="dropdown-item">Cambiar contraseña</a>
                    <!--<a href="javascript:;" class="dropdown-item"><span class="badge badge-danger pull-right">2</span> Inbox</a>-->
                    <!--<a href="javascript:;" class="dropdown-item">Calendar</a>
                    <a href="javascript:;" class="dropdown-item">Setting</a>-->
                    <div class="dropdown-divider"></div>
                    <a href="<?= Yii::getAlias('@web') ?>/sesion/cerrar/" class="dropdown-item">Salir</a>
                </div>
            </li>
            <li class="divider"></li>
        	<li class="dropdown dropdown-hover">
				<a href="#" class="header-cart" data-toggle="dropdown">
					<i class="fa fa-shopping-bag"></i>
					<?php
					   $count = 0;
					   if(isset($_SESSION['bolsa'])) {
					       $carrito = $_SESSION['bolsa'];
					       $count = count($carrito);
					   }
				    ?>
					<span class="total"><?= $count ?></span>
					<span class="arrow top"></span>
				</a>
				<div class="dropdown-menu dropdown-menu-cart p-0">
    				<div class="cart-header">
    					<h4 class="cart-title">Bolsa de compra</h4>
    				</div>
                    <?php  try { ?>
    				<div class="cart-body">
						<?php 
						//try {
						    $sw=false;
						    if(isset($_SESSION['bolsa'])) {
						        $carrito = $_SESSION['bolsa'];
						        $count = count($carrito);
						        for ($row = 0; $row < $count; $row++) {
        						        if(!$sw){
        						            ?>
        						            <ul class="cart-item">
        						            <?php
        						        }
        						        ?>
        						        <li>
            								<div class="cart-item-image"><img src="<?= Yii::getAlias('@web') . '/menu/descargar-platillo/?id='.$carrito[$row]['idMenuPlatillo'] ?>" alt="" /></div>
            								<div class="cart-item-info">
            									<h4><?= $carrito[$row]['platillo'] ?></h4>
            									<p class="price"><?= $carrito[$row]['precio'] ?></p>
            								</div>
            								<div class="cart-item-close">
            									<a href="#" data-toggle="tooltip" class="quitarPlatillo" data-title="quitar" id="quitarPlatillo_<?= $carrito[$row]['idMenuPlatillo'] ?>">&times;</a>
            								</div>
        								</li>
        						        <?php
        						        $sw = true;
        						?>
        						<?php
    						    }
						    }?>
						</ul>
					</div>
					<div class="cart-footer">
						<div class="row row-space-10">
							<div class="col-xs-6">
								<a href="<?= Yii::getAlias('@web') . '/pedido-menu/realizar-pedido' ?>" class="btn btn-default btn-block">Ver Carrito</a>
							</div>
						</div>
					</div>
						<?php
						} catch (\Exception $ex) { echo $ex->getMessage();}
						?>
    			</div>
			</li>
        </ul>
    <!-- end header navigation right -->
    </div>

    <!-- begin #sidebar -->
    <div id="sidebar" class="sidebar">
        <!-- begin sidebar scrollbar -->
        <div data-scrollbar="true" data-height="100%">
            <!-- begin sidebar user -->
            <ul class="nav">
                <!--
                <li class="nav-profile">
                    <a href="javascript:;" data-toggle="nav-profile">
                        <div class="cover with-shadow"></div>
                        <div class="image">
                            <img src="/themes/ColorAdmin/img/user/user-13.jpg" alt="" />
                        </div>
                        <div class="info">
                            <b class="caret pull-right"></b>
                            Menú
                            <small>Ayuda</small>
                        </div>
                    </a>
                </li>
                -->

                <li class="nav-profile">
                    <div class="cover with-shadow"></div>
                    <div class="image">
<!--                         <img src=" Yii::getAlias('@web')  /images/persona-profile.jpg" alt="" /> -->
<!--                         /images/foto_base.jpg -->
<!-- 							themes/ColorAdmin/img/user/user-13.jpg	 -->
<!-- 								/images/persona-profile.jpg	 -->
                    </div>
                    <div class="info">

                    </div>
                </li>
                <!--li>
                    <ul class="nav nav-profile">
                        <li><a href="javascript:;"><i class="fa fa-cog"></i> Configuración</a></li>
                        <li><a href="javascript:;"><i class="fa fa-pencil-alt"></i> Send Feedback</a></li>
                        <li><a href="javascript:;"><i class="fa fa-question-circle"></i> Ayuda</a></li>
                    </ul>
                </li-->
            </ul>
            <!-- end sidebar user -->
            <!-- begin sidebar nav -->
            <ul class="nav">
                <li class="nav-header">Menú</li>

                <?php
                if(Yii::$app->user->isGuest) {} //ANÓNIMO
                elseif($idTipoUsuario == 1) {//SUPERADMINISTRADOR
                ?>

                    <li class="has-sub">
                        <a href="<?= Yii::getAlias('@web') . '/sesion/' ?>">
                            <b class="caret"></b>
                            <i class="fa fa-home"></i>
                            <span>Inicio</span>
                        </a>
                    </li>
                    
                    <li class="has-sub">
                        <a href="javascript:;">
                            <b class="caret"></b>
                            <i class="fa fa-folder-open"></i>
                            <span>Catálogos Usuarios</span>
                        </a>
                        <ul class="sub-menu">
                            <li class="has-sub">
                                <a href="<?= Yii::getAlias('@web') . '/perfil/' ?>">
                                    <b class="caret"></b>
                                    <i class="fa fa-user"></i>
                                    <span>Perfiles</span>
                                </a>
                            </li>
                            <li class="has-sub">
                                <a href="<?= Yii::getAlias('@web') . '/usuario/' ?>">
                                    <b class="caret"></b>
                                    <i class="fa fa-users"></i>
                                    <span>Usuarios</span>
                                </a>
                            </li>
                        </ul>
    				</li>
					<li class="has-sub">
                        <a href="javascript:;">
                            <b class="caret"></b>
                            <i class="fa fa-folder-open"></i>
                            <span>Catálogos Administrativos</span>
                        </a>
                        <ul class="sub-menu">
                            <li class="has-sub">
                                <a href="<?= Yii::getAlias('@web') . '/leyenda-correo/' ?>">
                                    <b class="caret"></b>
                                    <i class="fa fa-envelope"></i>
                                    <span>Leyenda Correo</span>
                                </a>
                            </li>
                            <li class="has-sub">
                                <a href="<?= Yii::getAlias('@web') . '/aviso/' ?>">
                                    <b class="caret"></b>
                                    <i class="fa fa-comments"></i>
                                    <span>Avisos</span>
                                </a>
                            </li>
                        </ul>
    				</li>
                    <li class="has-sub">
                        <a href="<?= Yii::getAlias('@web') . '/reservacion/' ?>">
                            <b class="caret"></b>
                            <i class="fa fa-calendar"></i>
                            <span>Reservaciones</span>
                        </a>
                    </li>
					<li class="has-sub">
                        <a href="<?= Yii::getAlias('@web') . '/calendario/ver' ?>">
                            <b class="caret"></b>
                            <i class="fa fa-calendar-alt"></i>
                            <span>Calendario</span>
                        </a>
                    </li>
                    <li class="has-sub">
                        <a href="<?= Yii::getAlias('@web') . '/salida-fija/salida' ?>">
                            <b class="caret"></b>
                            <i class="fa fa-flag"></i>
                            <span>Salidas Fijas</span>
                        </a>
                    </li>
                    <li class="has-sub">
                        <a href="<?= Yii::getAlias('@web') . '/estacionamiento/' ?>">
                            <b class="caret"></b>
                            <i class="fa fa-parking"></i>
                            <span>Estacionamiento</span>
                        </a>
                    </li>
                    <li class="has-sub">
                        <a href="<?= Yii::getAlias('@web') . '/menu/menu' ?>">
                            <b class="caret"></b>
                            <i class="fa fa-utensils"></i>
                            <span>Menú</span>
                        </a>
                    </li>
                    <li class="has-sub">
                        <a href="<?= Yii::getAlias('@web') . '/pedido-menu' ?>">
                            <b class="caret"></b>
                            <i class="fa fa-edit"></i>
                            <span>Pedidos</span>
                        </a>
                    </li>
                    <li class="has-sub">
                        <a href="javascript:;">
                            <b class="caret"></b>
                            <i class="fa fa-cog"></i>
                            <span>Configuración de vistas</span>
                        </a>
                        <ul class="sub-menu">
                            <li class="has-sub">
                                <a href="<?= Yii::getAlias('@web') . '/profesor/' ?>">
                                    <b class="caret"></b>
                                    <i class="fa fa-book"></i>
                                    <span>Profesores</span>
                                </a>
                            </li>
                            <li class="has-sub">
                                <a href="<?= Yii::getAlias('@web') . '/seccion/' ?>">
                                    <b class="caret"></b>
                                    <i class="fa fa-th"></i>
                                    <span>Vistas</span>
                                </a>
                            </li>
                        </ul>
    				</li>
                    <?php
                    } elseif($idTipoUsuario == 2) {//SOCIO
                        ?>

                        <li class="has-sub">
                            <a href="<?= Yii::getAlias('@web') . '/sesion/' ?>">
                                <b class="caret"></b>
                                <i class="fa fa-home"></i>
                                <span>Inicio</span>
                            </a>
                        </li>
                        <li class="has-sub">
                            <a href="<?= Yii::getAlias('@web') . '/calendario/ver' ?>">
                                <b class="caret"></b>
                                <i class="fa fa-calendar-alt"></i>
                                <span>Calendario</span>
                            </a>
                        </li>
                        <li class="has-sub">
                            <a href="<?= Yii::getAlias('@web') . '/salida-fija/salida' ?>">
                                <b class="caret"></b>
                                <i class="fa fa-flag"></i>
                                <span>Salidas Fijas</span>
                            </a>
                        </li>
                        <li class="has-sub">
                            <a href="<?= Yii::getAlias('@web') . '/estacionamiento/registrar-solicitud' ?>">
                                <b class="caret"></b>
                                <i class="fa fa-parking"></i>
                                <span>Estacionamiento</span>
                            </a>
                        </li>
                        <?php
                    } elseif($idTipoUsuario == 3) {//FAMILIAR
                        ?>
                    	<li class="has-sub">
                            <a href="<?= Yii::getAlias('@web') . '/sesion/' ?>">
                                <b class="caret"></b>
                                <i class="fa fa-home"></i>
                                <span>Inicio</span>
                            </a>
                        </li>
                        <li class="has-sub">
                            <a href="<?= Yii::getAlias('@web') . '/calendario/ver' ?>">
                                <b class="caret"></b>
                                <i class="fa fa-calendar-alt"></i>
                                <span>Calendario</span>
                            </a>
                        </li>
                        <li class="has-sub">
                            <a href="<?= Yii::getAlias('@web') . '/salida-fija/salida' ?>">
                                <b class="caret"></b>
                                <i class="fa fa-flag"></i>
                                <span>Salidas Fijas</span>
                            </a>
                        </li>
                        <li class="has-sub">
                            <a href="<?= Yii::getAlias('@web') . '/estacionamiento/registrar-solicitud' ?>">
                                <b class="caret"></b>
                                <i class="fa fa-parking"></i>
                                <span>Salidas Fijas</span>
                            </a>
                        </li>
                    <?php
                    } else {
                    ?>

                    <?php
                    }
                    ?>

            </ul>
            <!-- end sidebar nav -->
        </div>
        <!-- end sidebar scrollbar -->
    </div>
    <div class="sidebar-bg"></div>
    <!-- end #sidebar -->

    <!-- begin #content -->
    <div id="content" class="content">
        <!-- begin breadcrumb -->

        <?php
        /*
        <div class="panel panel-inverse">
            <div class="panel-heading">
                <div class="panel-heading-btn">
                </div>
                <h4 class="panel-title"><?= $this->title ?></h4>
            </div>
            <div class="panel-body">
                <?// $content ?>
            </div>
        </div>
         */
        ?>

        <?= $content ?>


    </div>
    <!-- end theme-panel -->

    <!-- begin scroll to top btn -->
    <a href="javascript:;" class="btn btn-icon btn-circle btn-success btn-scroll-to-top fade" data-click="scroll-top"><i class="fa fa-angle-up"></i></a>
    <!-- end scroll to top btn -->
</div>
<!-- end page container -->


<?php $this->endBody() ?>
</body>
</html>
<?php $this->endPage() ?>
