<?php
/*
 * main.php
 * ABM
 * Copyright ©: 2019 Integrasoft. Todos los derechos reservados.
 * Desarrollador(es):
 *      L.I. Humberto Javier Flores Tirado.
 * Fecha de creación: 19/06/2019.
 * Fecha de modificación: 19/06/2019.
 * Descripción:
 */

use app\widgets\Alert;
use yii\helpers\Html;
use yii\bootstrap\Nav;
use yii\bootstrap\NavBar;
use yii\widgets\Breadcrumbs;
use app\assets\AppAsset;

AppAsset::register($this);
?>

<?php $this->beginPage() ?>
<!DOCTYPE html>
<html lang="<?= Yii::$app->language ?>">
<head>
    <meta charset="<?= Yii::$app->charset ?>">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <?= Html::csrfMetaTags() ?>
    <title><?= Html::encode($this->title) ?></title>
    <?php $this->head() ?>
</head>
<body>
<?php $this->beginBody() ?>

<div class="wrap">
    <?php
    NavBar::begin([
        'brandLabel' => Yii::$app->name,
        'brandUrl' => Yii::$app->homeUrl,
        'options' => [
            'class' => 'navbar-inverse navbar-fixed-left',
        ],
    ]);

    /*
    echo Nav::widget([
        'options' => ['class' => 'navbar-nav navbar-right'],
        //'options' => ['class' => 'nav-pills'],
        'items' => [
            ['label' => 'Home', 'url' => ['/site/index']],
            ['label' => 'About', 'url' => ['/site/about']],
            ['label' => 'Contact', 'url' => ['/site/contact']],
            Yii::$app->user->isGuest ? (
            ['label' => 'Login', 'url' => ['/site/login']]
            ) : (
                '<li>'
                . Html::beginForm(['/site/logout'], 'post')
                . Html::submitButton(
                    'Logout (' . Yii::$app->user->identity->username . ')',
                    ['class' => 'btn btn-link logout']
                )
                . Html::endForm()
                . '</li>'
            )
        ],
    ]);
    NavBar::end();
    */

    $itemsMenu[] = ['label' => 'Inicio', 'url' => ['/sesion/iniciar']];
    //$itemsMenu[] = ['label' => 'Créditos', 'url' => ['/sesion/creditos']];
    //$itemsMenu[] = ['label' => 'Cámara', 'url' => ['/camara/camara']];

    $menu = Nav::widget([
        'options' => ['class' => 'navbar-nav navbar-right'],
        'items' => $itemsMenu,
    ]);

    echo $menu;
    NavBar::end();
    ?>

    <div class="container">
        <?= Breadcrumbs::widget
        (
            [
                'homeLink' => [
                    'label' => 'Inicio',
                    'url' => Yii::$app->homeUrl,
                ],
                'links' => isset($this->params['breadcrumbs']) ? $this->params['breadcrumbs'] : [],
            ]
        ) ?>
        <?= Alert::widget() ?>



        <?= $content ?>
    </div>
</div>

<footer class="footer">
    <div class="container">
        <div class="pull-right hidden-xs">
            <b>Versión</b> <?= Yii::$app->params['version'] ?>
        </div>
        <strong>
            Copyright &copy;
            <?= Yii::$app->name ?> <?= date('Y') ?>.
        </strong> Todos los derechos reservados.
    </div>
</footer>

<?php $this->endBody() ?>
</body>
</html>
<?php $this->endPage() ?>
