<?php
/*
 * main.php
 * Reporte Movil
 * Copyright ©: 2018 Integrasoft. Todos los derechos reservados.
 * Desarrollador(es):
 *      L.I. Humberto Javier Flores Tirado.
 * Fecha de creación: 28/08/18.
 * Fecha de modificación: 04/10/18.
 * Descripción:
 */

use app\widgets\Alert;
use yii\helpers\Html;
use yii\bootstrap\Nav;
use yii\bootstrap\NavBar;
use yii\widgets\Breadcrumbs;
use app\assets\AppAsset;

AppAsset::register($this);
?>
<?php $this->beginPage() ?>
<!DOCTYPE html>
<html lang="<?= Yii::$app->language ?>">
<head>
    <meta charset="<?= Yii::$app->charset ?>">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <?= Html::csrfMetaTags() ?>
    <title><?= Html::encode($this->title) ?></title>
    <?php $this->head() ?>
    <link href="/css/navbar-fixed-left.min.css" rel="stylesheet"></head>
</head>
<body>
<?php $this->beginBody() ?>

<div class="wrap">
    <?php
    $nombreUsuario = "";
    $itemsMenu = null;

    if(isset(Yii::$app->user->identity))
        $nombreUsuario =  '(' . Yii::$app->user->identity->nombre . ' ' . Yii::$app->user->identity->apellidos . ')';

    NavBar::begin([
        'brandLabel' => Yii::$app->name . '<br />' . $nombreUsuario,
        'brandUrl' => Yii::$app->homeUrl,
        'options' => [
            'class' => 'navbar-inverse navbar-fixed-left',
        ],
    ]);

    if(Yii::$app->user->isGuest)//2 ANÓNIMO
    {
        $itemsMenu[] = ['label' => 'Inicio', 'url' => ['/sesion/']];
        $itemsMenu[] = ['label' => 'Créditos', 'url' => ['/sesion/creditos']];
    }
    elseif(Yii::$app->user->identity->rolUsuario->idRolUsuario == 1) //ADMINISTRADOR
    {
        $itemsMenu[] = ['label' => 'Inicio', 'url' => ['/sesion/']];
        $itemsMenu[] = ['label' => 'Actualizar carrusel', 'url' => ['/carrusel/']];
        $itemsMenu[] = ['label' => 'Gestionar administrativos', 'url' => ['/administrativo/']];
        $itemsMenu[] = ['label' => 'Gestionar instituciones', 'url' => ['/institucion/']];
        $itemsMenu[] = ['label' => 'Gestionar ciudadanos', 'url' => ['/ciudadano/']];
        $itemsMenu[] = ['label' => 'Gestionar cuadrillas', 'url' => ['/cuadrilla/']];
        $itemsMenu[] = ['label' => 'Gestionar tipos de reporte', 'url' => ['/tipo-reporte/']];
        $itemsMenu[] = ['label' => 'Gestionar reporte', 'url' => ['/reporte/']];
        $itemsMenu[] = ['label' => 'Actualizar datos', 'url' => ['/administrativo/actualizar-datos']];
        $itemsMenu[] = ['label' => 'Cambiar contraseña', 'url' => ['/sesion/cambiar-contrasenia']];
        $itemsMenu[] = ['label' => 'Cerrar sesión', 'url' => ['/sesion/cerrar']];
        //$itemsMenu[] = ['label' => 'Créditos', 'url' => ['/site/creditos']];

    }
    elseif(Yii::$app->user->identity->rolUsuario->idRolUsuario == 3) //ASESOR
    {
        $itemsMenu[] = ['label' => 'Inicio', 'url' => ['/sesion/']];
        $itemsMenu[] = ['label' => 'Gestionar cuadrillas', 'url' => ['/cuadrilla/']];
        $itemsMenu[] = ['label' => 'Gestionar reporte', 'url' => ['/reporte/']];
        $itemsMenu[] = ['label' => 'Actualizar datos', 'url' => ['/administrativo/actualizar-datos']];
        $itemsMenu[] = ['label' => 'Cambiar contraseña', 'url' => ['/sesion/cambiar-contrasenia']];
        $itemsMenu[] = ['label' => 'Cerrar sesión', 'url' => ['/sesion/cerrar']];
        //$itemsMenu[] = ['label' => 'Créditos', 'url' => ['/site/creditos']];
    }
    elseif(Yii::$app->user->identity->rolUsuario->idRolUsuario == 4) //CIUDADANO
    {
        $itemsMenu[] = ['label' => 'Inicio', 'url' => ['/sesion/']];
        $itemsMenu[] = ['label' => 'Registrar reporte', 'url' => ['/reporte/registrar']];
        $itemsMenu[] = ['label' => 'Mis reportes', 'url' => ['/reporte/mis-reportes']];
        $itemsMenu[] = ['label' => 'Actualizar datos', 'url' => ['/ciudadano/actualizar-datos']];
        $itemsMenu[] = ['label' => 'Cambiar contraseña', 'url' => ['/sesion/cambiar-contrasenia/']];
        $itemsMenu[] = ['label' => 'Cerrar sesión', 'url' => ['/sesion/cerrar']];
        //$itemsMenu[] = ['label' => 'Créditos', 'url' => ['/site/creditos']];
    }
    elseif(Yii::$app->user->identity->rolUsuario->idRolUsuario == 5) //INSTITUCIÓN
    {
        $itemsMenu[] = ['label' => 'Inicio', 'url' => ['/sesion/']];
        $itemsMenu[] = ['label' => 'Registrar reporte', 'url' => ['/reporte/registrar']];
        $itemsMenu[] = ['label' => 'Mis reportes', 'url' => ['/reporte/mis-reportes']];
        $itemsMenu[] = ['label' => 'Actualizar datos', 'url' => ['/institucion/actualizar-datos']];
        $itemsMenu[] = ['label' => 'Cambiar contraseña', 'url' => ['/sesion/cambiar-contrasenia/']];
        $itemsMenu[] = ['label' => 'Cerrar sesión', 'url' => ['/sesion/cerrar']];
        //$itemsMenu[] = ['label' => 'Créditos', 'url' => ['/site/creditos']];
    }
    else
    {
        $itemsMenu[] = ['label' => 'Inicio', 'url' => ['/sesion/']];
    }

    $menu = Nav::widget([
        'options' => ['class' => 'navbar-nav navbar-right'],
        'items' => $itemsMenu,
    ]);

    echo $menu;
    NavBar::end();

    ?>

    <div class="container" style="width: 90%">
        <?= Breadcrumbs::widget([
            'homeLink' => [
                'label' => 'Inicio',
                //'url' => Yii::$app->homeUrl,
                'url' => '/sesion/',
            ],
            'links' => isset($this->params['breadcrumbs']) ? $this->params['breadcrumbs'] : [],
        ]) ?>
        <?= Alert::widget() ?>
        <?= $content ?>
    </div>
</div>

<footer class="footer">
    <div class="container">
        <p class="pull-left">&copy; <?= Yii::$app->name ?> <?= date('Y') ?></p>

        <p class="pull-right"><?// Yii::powered() ?></p>
    </div>
</footer>

<?php $this->endBody() ?>
</body>
</html>
<?php $this->endPage() ?>
