<?php
/*
 * index.php
 * Springfield
 * Copyright ©: 2022 Integrasoft. Todos los derechos reservados.
 * Desarrollador(es):
 *      L.I. Humberto Javier Flores Tirado.
 * Fecha de creación: 25/03/2022.
 * Fecha de modificación: 25/03/2022.
 * Descripción:
 */

use yii\grid\GridView;
use yii\helpers\Html;
use dosamigos\datepicker\DatePicker;

echo $this->registerJsFile
(
    '@web/js/rol-usuario/index.js',
    ['depends' =>
        [
            \yii\web\JqueryAsset::className(),
            \yii\jui\JuiAsset::className()
        ]
    ]
);

$this->title = 'Roles de usuario';
$this->params['breadcrumbs'][] = $this->title;
?>

<h3><?= $this->title ?></h3><hr />

<?= Html::a('Registrar', ['/rol-usuario/registrar'], ['class'=>'btn btn-success']) ?>
<br /><br />

<div id="dialog-eliminar" title="Eliminar rol de usuario">
    <p>
        <span id="dialog-eliminar-confirmacion"></span>
    </p>
    <div id="ruta-eliminar" style="display: none;"><?= Yii::getAlias('@web') ?></div>
</div>

<div class="filtros">
    <?php
    $createDateDatePicker = DatePicker::widget
    (
        [
            'model' => $searchModel,
            'attribute' => 'createDate',
            'template' => '{addon}{input}',
            'clientOptions' =>
                [
                    'autoclose' => true,
                    'format' => 'yyyy-mm-dd'
                ]
        ]
    );

    $recordDateDatePicker = DatePicker::widget
    (
        [
            'model' => $searchModel,
            'attribute' => 'recordDate',
            'template' => '{addon}{input}',
            'clientOptions' =>
                [
                    'autoclose' => true,
                    'format' => 'yyyy-MM-dd'
                ]
        ]
    );
    ?>

    <?= GridView::widget([
        'dataProvider' => $dataProvider,
        'filterModel' => $searchModel,
        'summary' => 'Visualizados {begin} - {end} de {totalCount} resultados',
        'emptyText' => 'No se encontraron resultados',
        'pager' => [
            'firstPageLabel' => '|<',
            'prevPageLabel' => '<<',
            'nextPageLabel' => '>>',
            'lastPageLabel' => '>|'
        ],
        'columns' => [
            [
                'class' => 'yii\grid\ActionColumn',
                'header' => 'Operaciones',
                'buttons' => [
                    'view' => function ($url, $model, $key) {
                        return Html::a('<span class="glyphicon glyphicon-eye-open"></span>', $url,
                            ['title' => 'Ver']);
                    },
                    'update' => function ($url, $model, $key) {
                        return Html::a('<span class="glyphicon glyphicon-edit"></span>', $url,
                            ['title' => 'Actualizar']);
                    },
                    'delete' => function ($url, $model, $key) {
                        return Html::a('<span class="glyphicon glyphicon-trash"></span>', $url,
                            ['class' => 'eliminar-rol-usuario', 'title' => 'Eliminar', 'id' => $key, 'name' => $model->rolUsuario]);
                    },
                ],
                'urlCreator' => function($action, $model, $key, $index) {
                    if($action === 'view')
                        return Yii::getAlias('@web') . '/rol-usuario/ver?id=' . $model->idRolUsuario;
                    elseif($action == 'update')
                        return Yii::getAlias('@web') . '/rol-usuario/actualizar?id=' . $model->idRolUsuario;
                    elseif($action == 'delete')
                        return 'javascript:;';
                }
            ],
            'rolUsuario',
            [
                'attribute' => 'createDate',
                'filter' => $createDateDatePicker,
            ],
            [
                'attribute' => 'recordDate',
                'filter' => $recordDateDatePicker,
            ],
        ],
    ]); ?>
</div>

<br />
<?= Html::a('Registrar', ['/rol-usuario/registrar'], ['class'=>'btn btn-success']) ?>
