<?php
/*
 * ver.php
 * Springfield
 * Copyright ©: 2022 Integrasoft. Todos los derechos reservados.
 * Desarrollador(es):
 *      L.I. Humberto Javier Flores Tirado.
 * Fecha de creación: 25/03/2022.
 * Fecha de modificación: 25/03/2022.
 * Descripción:
 */

use yii\helpers\Html;
use yii\widgets\ActiveForm;

$this->title = 'Ver rol de usuario';
$this->params['breadcrumbs'][] = ['label' => 'Roles de usuario', 'url' => ['index']];
$this->params['breadcrumbs'][] = $this->title;

//Inicia el formulario
$form = ActiveForm::begin([
    'method' => 'post',
    'id' => 'rol-usuario-form',
    'enableClientValidation' => true,
    'enableAjaxValidation' => false,
]);
?>

    <h3><?= $this->title ?></h3><hr />

    <div style="text-align: left; width: 100%">
        <?= Html::a('Regresar', ['/rol-usuario/'], ['class'=>'btn btn-primary']) ?>
    </div>
    <br />

    <div class="group-form">
        <?= $form->field($model, 'rolUsuario')->input('text', ['maxlength' => 100, 'placeholder' => 'Introduce un rol de usuario', 'disabled' => true]) ?>
    </div>

    <div class="group-form">
        <?= $form->field($model, 'permisos')->listBox($listaPermisos, [
            'multiple' => true,
            'size' => 20,
            'disabled' => true,
        ]) ?>
    </div>

    <div style="text-align: left; width: 100%">
        <?= Html::a('Regresar', ['/rol-usuario/'], ['class'=>'btn btn-primary']) ?>
    </div>

<?php $form->end(); ?>