<?php
/*
 * iniciar.php
 * Springfield
 * Copyright ©: 2022 Integrasoft. Todos los derechos reservados.
 * Desarrollador(es):
 *      L.I. Humberto Javier Flores Tirado.
 *      I.S.C Julio Alberto Ocampo Rangel.
 * Fecha de creación: 25/03/2022.
 * Fecha de modificación: 31/03/2022.
 * Descripción:
 */

use yii\helpers\Html;
use yii\widgets\ActiveForm;

$this->title = 'Iniciar sesión';

$form = ActiveForm::begin([
    'method' => 'post',
    'id' => 'iniciar-sesion-formulario',
    'enableClientValidation' => true,
    'enableAjaxValidation' => false,
]);
?>
<br/>
<br/>
<div class="col-md-6 col-md-offset-3">
    <div class="panel panel-default">
        <div class="panel-body">
            <h2><?= $this->title ?></h2>
            <hr>
            <div class="group-form">
                <?= $form->field($model, 'usuario')->input('text', ['maxlength' => 50]) ?>
            </div>

            <div class="group-form">
                <?= $form->field($model, 'contrasenia')->input('password', ['maxlength' => 50]) ?>
            </div>

            <?=
            Html::submitButton('Iniciar sesi&oacute;n',
                ['class' => 'btn btn-success', 'title' => 'Iniciar sesión...'])
            ?>

            <p style="margin-top: 1em;">
                <?=
                Html::a("¿Olvidaste tu contrase&ntilde;a?", ["/sesion/recuperar-contrasenia"],
                    ['title' => 'Recuperar contraseña...'])
                ?>
            </p>

            <p style="margin-top: 1em;">
                <?=
                Html::a("Registrarse", ["/sustentante/registrarse"],
                    ['title' => 'Registrarse...'])
                ?>
            </p>        
        </div>
    </div>
</div>

<?php $form->end(); ?>
