<?php
/*
 * cambiar-contrasenia.php
 * Springfield
 * Copyright ©: 2022 Integrasoft. Todos los derechos reservados.
 * Desarrollador(es):
 *      L.I. Humberto Javier Flores Tirado.
 * Fecha de creación: 25/03/2022.
 * Fecha de modificación: 30/03/2022.
 * Descripción:
 */

use yii\helpers\Html;
use yii\widgets\ActiveForm;

$this->title = 'Recuperar contraseña';
$this->params['breadcrumbs'][] = $this->title;

$form = ActiveForm::begin([
    'method' => 'post',
    'id' => 'recuperar-contrasenia2-form',
    'enableClientValidation' => false,
    'enableAjaxValidation' => true,
]);
?>

<?php
if(Yii::$app->session->hasFlash('success')) {
    ?>
    <div class="alert alert-success" role="alert">
        <?= Yii::$app->session->getFlash('success') ?>
    </div>
    <?php
} elseif(Yii::$app->session->hasFlash('error')) {
    ?>
    <div class="alert alert-danger" role="alert">
        <?= Yii::$app->session->getFlash('error') ?>
    </div>
    <?php
}
?>

<div class="row">
    <div class="col-md-6">

        <div class="panel panel-inverse">
            <div class="panel-heading">
                <div class="panel-heading-btn">
                </div>
                <h4 class="panel-title"><?= $this->title ?></h4>
            </div>
            <div class="panel-body">

                <div style="text-align: left; width: 100%">
                    <?= Html::submitButton('Guardar', ['class' => 'btn btn-success', 'title' => 'Guardar...']) ?>
                </div>
                <br />
                
                <div class="group-form">
                	<?= $form->field($model, 'usuario')->hiddenInput(['value' => $model->usuario])->label(false) ?>
                    <?= $form->field($model, 'apellidos')->input('text', ['maxlength' => 100]) ?>
                </div>
                
                <div class="group-form">
                    <?= $form->field($model, 'contrasenia')->input('password', ['maxlength' => 50]) ?>
                </div>

                <div class="group-form">
                    <?= $form->field($model, 'confirmaContrasenia')->input('password', ['maxlength' => 50]) ?>
                </div>

                <div style="text-align: left; width: 100%">
                    <?= Html::submitButton('Guardar', ['class' => 'btn btn-success', 'title' => 'Guardar...']) ?>
                </div>

            </div>
        </div>

    </div>
</div>


<?php $form->end(); ?>
