<?php
/*
 * index.php
 * Springfield
 * Copyright ©: 2022 Integrasoft. Todos los derechos reservados.
 * Desarrollador(es):
 *      I.S.C Julio Alberto Ocampo Rangel.
 *      L.I. Humberto Javier Flores Tirado.
 * Fecha de creación: 28/03/2022.
 * Fecha de modificación: 02/06/2022.
 * Descripción:
 */

use yii\grid\GridView;
use yii\helpers\Html;
use dosamigos\datepicker\DatePicker;

echo $this->registerJsFile
(
    '@web/js/sustentante/index.js',
    ['depends' =>
        [
            \yii\web\JqueryAsset::class,
            \yii\jui\JuiAsset::class
        ]
    ]
);

$this->title = 'Sustentantes';
$this->params['breadcrumbs'][] = $this->title;
?>

<h3><?= $this->title ?></h3><hr />

<?= Html::a('Registrar', ['/sustentante/registrar'], ['class'=>'btn btn-success']) ?>
&nbsp;

<?php
if(Yii::$app->user->identity->rolUsuario->idRolUsuario == 1)
    echo Html::a('Exportar', ['/sustentante/exportar'], ['class'=>'btn btn-default']);
?>

<br /><br />

<div id="dialog-eliminar" title="Eliminar sustentante">
    <p>
        <span id="dialog-eliminar-confirmacion"></span>
    </p>
    <div id="ruta-eliminar" style="display: none;"><?= Yii::getAlias('@web') ?></div>
</div>

<div class="filtros">
    <?php
    $createDateDatePicker = DatePicker::widget
    (
        [
            'model' => $searchModel,
            'attribute' => 'createDate',
            'template' => '{addon}{input}',
            'clientOptions' =>
                [
                    'autoclose' => true,
                    'format' => 'yyyy-mm-dd'
                ]
        ]
    );

    $recordDateDatePicker = DatePicker::widget
    (
        [
            'model' => $searchModel,
            'attribute' => 'recordDate',
            'template' => '{addon}{input}',
            'clientOptions' =>
                [
                    'autoclose' => true,
                    'format' => 'yyyy-MM-dd'
                ]
        ]
    );
    ?>

    <?= GridView::widget([
        'dataProvider' => $dataProvider,
        'filterModel' => $searchModel,
        'summary' => 'Visualizados {begin} - {end} de {totalCount} resultados',
        'emptyText' => 'No se encontraron resultados',
        'pager' => [
            'firstPageLabel' => '|<',
            'prevPageLabel' => '<<',
            'nextPageLabel' => '>>',
            'lastPageLabel' => '>|'
        ],
        'columns' => [
            [
                'class' => 'yii\grid\ActionColumn',
                'header' => 'Operaciones',
                'template' => '{view} {update} {validar} {delete} {exportar}',
                'buttons' => [
                    'view' => function ($url, $model, $key) {
                        return Html::a('<span class="glyphicon glyphicon-eye-open"></span>', $url,
                            ['title' => 'Ver']);
                    },
                    'update' => function ($url, $model, $key) {
                        return Html::a('<span class="glyphicon glyphicon-edit"></span>', $url,
                            ['title' => 'Actualizar']);
                    },
                    'validar' => function ($url, $model, $key) {
                        return Html::a('<span class="glyphicon glyphicon-check"></span>', $url,
                            ['title' => 'Validar']);
                    },
                    'delete' => function ($url, $model, $key) {
                        return Html::a('<span class="glyphicon glyphicon-trash"></span>', $url,
                            ['class' => 'eliminar-sustentante', 'title' => 'Eliminar', 'id' => $key, 'name' => $model->usuario->nombre . ' ' . $model->usuario->primerApellido . ' ' . $model->usuario->segundoApellido ]);
                    },
                ],
                'urlCreator' => function($action, $model, $key, $index) {
                    if($action === 'view')
                        return Yii::getAlias('@web') . '/sustentante/ver?id=' . $model->idSustentante;
                    elseif($action == 'update')
                        return Yii::getAlias('@web') . '/sustentante/actualizar?id=' . $model->idSustentante;
                    elseif($action == 'validar')
                        return Yii::getAlias('@web') . '/sustentante/validar?id=' . $model->idSustentante;
                    elseif($action == 'delete')
                        return 'javascript:;';
                }
            ],
            [
                'attribute' => 'idSede',
                'value' => function ($model, $key, $index, $column) {
                    if(isset($model->usuario->sede))
                        return $model->usuario->sede->sede;
                    else
                        return "";
                },

                'filter' => $listaSede,
            ],
            [
                'attribute' => 'idSexo',
                'value' => function ($model, $key, $index, $column) {
                    if(isset($model->sexo))
                        return $model->sexo->sexo;
                    else
                        return "";
                },

                'filter' => $listaSexo,
            ],
            [
                'attribute' => 'idEstado',
                'value' => function ($model, $key, $index, $column) {
                    if(isset($model->estado))
                        return $model->estado->estado;
                    else
                        return "";
                },

                'filter' => $listaEstado,
            ],
            [
                'attribute' => 'idNivelEducativo',
                'value' => function ($model, $key, $index, $column) {
                    if(isset($model->nivelEducativo))
                        return $model->nivelEducativo->nivelEducativo;
                    else
                        return "";
                },

                'filter' => $listaNivelEducativo,
            ],
            [
                'attribute' => 'idAreaConocimiento',
                'value' => function ($model, $key, $index, $column) {
                    if(isset($model->perfilProfesional->areaConocimiento))
                        return $model->perfilProfesional->areaConocimiento->areaConocimiento;
                    else
                        return "";
                },

                'filter' => $listaAreaConocimiento,
            ],
            [
                'attribute' => 'idMotivoNoConcluyo',
                'value' => function ($model, $key, $index, $column) {
                    if(isset($model->motivoNoConcluyo))
                        return $model->motivoNoConcluyo->motivoNoConcluyo;
                    else
                        return "";
                },

                'filter' => $listaMotivoNoConcluyo,
            ],
            [
                'attribute' => 'idAntecedenteAcademico',
                'value' => function ($model, $key, $index, $column) {
                    if(isset($model->antecedenteAcademico))
                        return $model->antecedenteAcademico->antecedenteAcademico;
                    else
                        return "";
                },

                'filter' => $listaAntecedenteAcademico,
            ],
            [
                'attribute' => 'idEstatusSustentante',
                'value' => function ($model, $key, $index, $column) {
                    if(isset($model->estatusSustentante))
                        return $model->estatusSustentante->estatusSustentante;
                    else
                        return "";
                },

                'filter' => $listaEstatusSustentante,
            ],
            [
                'attribute' => 'nombre',
                'value' => function ($model, $key, $index, $column) {
                    if(isset($model->usuario))
                        return $model->usuario->nombre;
                    else
                        return "";
                }
            ],
            [
                'attribute' => 'primerApellido',
                'value' => function ($model, $key, $index, $column) {
                    if(isset($model->usuario))
                        return $model->usuario->primerApellido;
                    else
                        return "";
                }
            ],
            [
                'attribute' => 'segundoApellido',
                'value' => function ($model, $key, $index, $column) {
                    if(isset($model->usuario))
                        return $model->usuario->segundoApellido;
                    else
                        return "";
                }
            ],
            'numeroControl',
            'curp',
            [
                'attribute' => 'createDate',
                'filter' => $createDateDatePicker,
            ],
            [
                'attribute' => 'recordDate',
                'filter' => $recordDateDatePicker,
            ],
        ],
    ]); ?>
</div>

<br />
<?= Html::a('Registrar', ['/sustentante/registrar'], ['class'=>'btn btn-success']) ?>
&nbsp;
<?php
if(Yii::$app->user->identity->rolUsuario->idRolUsuario == 1)
    echo Html::a('Exportar', ['/sustentante/exportar'], ['class'=>'btn btn-default']);
?>
