<?php
/*
 * registrar.php
 * Springfield
 * Copyright ©: 2022 Integrasoft. Todos los derechos reservados.
 * Desarrollador(es):
 *      I.S.C Julio Alberto Ocampo Rangel.
 *      L.I. Humberto Javier Flores Tirado.
 * Fecha de creación: 29/03/2022.
 * Fecha de modificación: 28/04/2022.
 * Descripción:
 */

use yii\helpers\Html;
use yii\widgets\ActiveForm;

$this->title = 'Registrar sustentante';
$this->params['breadcrumbs'][] = ['label' => 'Sustentantes', 'url' => ['index']];
$this->params['breadcrumbs'][] = $this->title;

echo $this->registerJsFile
(
    '@web/js/sustentante/registrar.js',
    ['depends' =>
        [
            \yii\web\JqueryAsset::class,
            \yii\jui\JuiAsset::class
        ]
    ]
);

//Inicia el formulario
$form = ActiveForm::begin([
    'method' => 'post',
    'id' => 'sustentante-form',
    'enableClientValidation' => true,
    'enableAjaxValidation' => false,
]);
?>

    <div id="ruta-web-app" style="display: none;"><?= Yii::getAlias('@web') ?></div>

    <h3><?= $this->title ?></h3><hr />

    <div style="text-align: left; width: 100%">
        <?= Html::a('Regresar', ['/sustentante/'], ['class'=>'btn btn-primary']) ?>
        &nbsp;
        <?= Html::submitButton('Guardar', ['class' => 'btn btn-success', 'title' => 'Guardar...']) ?>
    </div>
    <br />

    <div class="group-form">
        <div class="row">
            <div class="col-md-4">
                <?= $form->field($model, 'idEstado')->dropDownList($listaEstado, ['prompt' => 'Selecciona una opción...']) ?>
            </div>
        </div>
    </div>
    <div class="panel panel-info">
        <div class="panel-heading text-center"><strong>Datos generales del solicitante</strong></div>
        <div class="panel-body">
            <div class="group-form">
                <div class="row">
                    <div class="col-md-4">
                        <?= $form->field($model, 'nombre')->input('text', ['maxlength' => 100, 'placeholder' => 'Introduce el nombre']) ?>
                    </div>
                    <div class="col-md-4">
                        <?= $form->field($model, 'primerApellido')->input('text', ['maxlength' => 100, 'placeholder' => 'Introduce el primer apellido']) ?>
                    </div>
                    <div class="col-md-4">
                        <?= $form->field($model, 'segundoApellido')->input('text', ['maxlength' => 100, 'placeholder' => 'Introduce el segundo apellido']) ?>
                    </div>
                </div>
            </div>

            <div class="group-form">
                <div class="row">
                    <div class="col-md-4">
                        <?= $form->field($model, 'curp')->input('text', ['maxlength' => 18, 'placeholder' => 'Introduce el curp']) ?>
                    </div>
                    <div class="col-md-4">
                        <?= $form->field($model, 'fechaNacimiento')->input('date', ['maxlength' => 10, 'placeholder' => 'Introduce la fecha de nacimiento']) ?>
                    </div>
                    <div class="col-md-4">
                        <?= $form->field($model, 'idSexo')->dropDownList($listaSexo, ['prompt' => 'Selecciona una opción...']) ?>
                    </div>
                </div>
            </div>

            <div class="group-form">
                <div class="row">
                    <div class="col-md-4">
                        <?= $form->field($model, 'nacionalidad')->input('text', ['maxlength' => 50, 'placeholder' => 'Introduce la nacionalidad']) ?>
                    </div>
                    <div class="col-md-4">
                        <?= $form->field($model, 'lugarNacimiento')->input('text', ['maxlength' => 50, 'placeholder' => 'Introduce el lugar de nacimiento']) ?>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="panel panel-info">
        <div class="panel-heading text-center"><strong>Domicilio</strong></div>
        <div class="panel-body">
            <div class="group-form">
                <?= $form->field($model, 'calleNumero')->input('text', ['maxlength' => 100, 'placeholder' => 'Introduce la calle y el número']) ?>
            </div>

            <div class="group-form">
                <div class="row">
                    <div class="col-md-6">
                        <?= $form->field($model, 'colonia')->input('text', ['maxlength' => 50, 'placeholder' => 'Introduce la colonia']) ?>
                    </div>
                    <div class="col-md-6">
                        <?= $form->field($model, 'codigoPostal')->input('text', ['maxlength' => 5, 'placeholder' => 'Introduce el código postal']) ?>
                    </div>
                </div>
            </div>

            <div class="group-form">
                <div class="row">
                    <div class="col-md-6">
                        <?= $form->field($model, 'municipio')->input('text', ['maxlength' => 100, 'placeholder' => 'Introduce la colonia']) ?>
                    </div>
                    <div class="col-md-6">
                        <?= $form->field($model, 'idEstadoRadica')->dropDownList($listaEstado, ['prompt' => 'Selecciona una opción...']) ?>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="panel panel-info">
        <div class="panel-heading text-center"><strong>Teléfonos</strong></div>
        <div class="panel-body">
            <div class="group-form">
                <div class="row">
                    <div class="col-md-4">
                    <?= $form->field($model, 'telefonoCasa')->input('number', ['maxlength' => 10, 'placeholder' => 'Introduce el teléfono de casa']) ?>
                    </div>
                    <div class="col-md-4">
                        <?= $form->field($model, 'telefonoOficina')->input('number', ['maxlength' => 10, 'placeholder' => 'Introduce el télefono de oficina']) ?>
                    </div>
                    <div class="col-md-4">
                        <?= $form->field($model, 'celular')->input('number', ['maxlength' => 10, 'placeholder' => 'Introduce el celular']) ?>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="panel panel-info">
        <div class="panel-heading text-center"><strong>Perfil profesional que desea acreditar</strong></div>
        <div class="panel-body">
            <div class="group-form">
                <?= $form->field($model, 'idSede')->dropDownList($listaSede, ['prompt' => 'Selecciona una opción...']) ?>
            </div>
            <div class="group-form">
                <?= $form->field($model, 'idNivelEducativo')->dropDownList($listaNivelEducativo, ['prompt' => 'Selecciona una opción...']) ?>
            </div>
            <div class="group-form">
                <?= $form->field($model, 'idAreaConocimiento')->dropDownList($listaAreaConocimiento, ['prompt' => 'Selecciona una opción...']) ?>
            </div>
            <div class="group-form">
                <?= $form->field($model, 'idPerfilProfesional')->dropDownList([], ['prompt' => 'Selecciona una opción...']) ?>
            </div>
        </div>
    </div>

    <div class="panel panel-info">
        <div class="panel-heading text-center"><strong>Información académica</strong></div>
        <div class="panel-body">
            <div class="group-form">
                <?= $form->field($model, 'institucion')->input('text', ['maxlength' => 100, 'placeholder' => 'Introduce la institución']) ?>
            </div>
            <div class="group-form">
                <?= $form->field($model, 'porcentajeCreditosCursados')->input('number', ['maxlength' => 3, 'placeholder' => 'Introduce el porcentaje']) ?>
            </div>
        </div>
    </div>

    <div class="panel panel-info">
        <div class="panel-heading text-center"><strong>Motivo por el que no concluyó sus estudios o no se tituló</strong></div>
        <div class="panel-body">
            <div class="group-form">
                <?= $form->field($model, 'idMotivoNoConcluyo')->dropDownList($listaMotivoNoConcluyo, ['prompt' => 'Selecciona una opción...']) ?>
            </div>
            <div class="group-form">
                <?= $form->field($model, 'porcentajeCreditosCursados')->input('text', ['maxlength' => 200, 'placeholder' => 'Introduce otro motivo']) ?>
            </div>
        </div>
    </div>

    <div class="panel panel-info">
        <div class="panel-heading text-center"><strong>Antecedente académico</strong></div>
        <div class="panel-body">
            <div class="group-form">
                <?= $form->field($model, 'idAntecedenteAcademico')->dropDownList($listaAntecedenteAcademico, ['prompt' => 'Selecciona una opción...']) ?>
            </div>
            <div class="group-form">
                <?= $form->field($model, 'licenciatura')->input('text', ['maxlength' => 100, 'placeholder' => 'Introduce la licenciatura']) ?>
            </div>
            <div class="group-form">
                <?= $form->field($model, 'porcentajeCreditosObtenidos')->input('number', ['maxlength' => 3, 'placeholder' => 'Introduce el porcentaje']) ?>
            </div>
        </div>
    </div>

    <div class="panel panel-info">
        <div class="panel-heading text-center"><strong>Personas autorizadas</strong></div>
        <div class="panel-body">
            <div class="group-form">
                <div class="row">
                    <div class="col-md-6">
                        <?= $form->field($model, 'personaAutorizada1')->input('text', ['maxlength' => 100, 'placeholder' => 'Introduce a la persona autorizada']) ?>
                    </div>
                    <div class="col-md-6">
                    <?= $form->field($model, "archivoPersonaAutorizada1Upload")->fileInput() ?>
                    </div>
                </div>
            </div>
            <div class="group-form">
                <div class="row">
                    <div class="col-md-6">
                        <?= $form->field($model, 'personaAutorizada2')->input('text', ['maxlength' => 100, 'placeholder' => 'Introduce a la persona autorizada']) ?>
                    </div>
                    <div class="col-md-6">
                    <?= $form->field($model, "archivoPersonaAutorizada2Upload")->fileInput() ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <div class="panel panel-info">
        <div class="panel-heading text-center"><strong>Documentación</strong></div>
        <div class="panel-body">
            <div class="group-form">
                <?= $form->field($model, "archivoActaNacimientoUpload")->fileInput() ?>
            </div>
            <div class="group-form">
                <?= $form->field($model, "archivoCurpUpload")->fileInput() ?>
            </div>
            <div class="group-form">
                <?= $form->field($model, "archivoIneUpload")->fileInput() ?>
            </div>
            <div class="group-form">
                <?= $form->field($model, "archivoCertificadoUpload")->fileInput() ?>
            </div>
            <div class="group-form">
                <?= $form->field($model, "archivoAntecedenteSecundariaUpload")->fileInput() ?>
            </div>
            <div class="group-form">
                <?= $form->field($model, "archivoCurriculumUpload")->fileInput() ?>
            </div>
            <div class="group-form">
                <?= $form->field($model, "archivoDoctoUltimoGradoEstudiosUpload")->fileInput() ?>
            </div>
            <div class="group-form">
                <?= $form->field($model, "archivoCartaAutorizacionUpload")->fileInput() ?>
            </div>
        </div>
    </div>

    <div class="panel panel-info">
        <div class="panel-heading text-center"><strong>Datos de acceso</strong></div>
        <div class="panel-body">
            <div class="group-form">
                <?= $form->field($model, 'correoElectronico')->input('email', ['maxlength' => 100, 'placeholder' => 'Introduce tu correo electrónico']) ?>
            </div>
            <div class="group-form">
                <?= $form->field($model, 'contrasenia')->input('password', ['maxlength' => 100, 'placeholder' => 'Introduce la contraseña']) ?>
            </div>
            <div class="group-form">
                <?= $form->field($model, 'verificarContrasenia')->input('password', ['maxlength' => 100, 'placeholder' => 'Confirma la contraseña']) ?>
            </div>
        </div>
    </div>

    <div style="text-align: left; width: 100%">
        <?= Html::a('Regresar', ['/sustentante/'], ['class'=>'btn btn-primary']) ?>
        &nbsp;
        <?= Html::submitButton('Guardar', ['class' => 'btn btn-success', 'title' => 'Guardar...']) ?>
    </div>

<?php $form->end(); ?>