<?php
/*
 * index.php
 * Springfield
 * Copyright ©: 2022 Integrasoft. Todos los derechos reservados.
 * Desarrollador(es):
 *      L.I. Humberto Javier Flores Tirado.
 * Fecha de creación: 25/03/2022.
 * Fecha de modificación: 17/05/2022.
 * Descripción:
 */

use yii\grid\GridView;
use yii\helpers\Html;
use dosamigos\datepicker\DatePicker;
use yii\bootstrap\Modal;

echo $this->registerJsFile
(
    '@web/js/usuario/index.js',
    ['depends' =>
        [
            \yii\web\JqueryAsset::className(),
            \yii\jui\JuiAsset::className()
        ]
    ]
);

$this->title = 'Usuarios';
$this->params['breadcrumbs'][] = $this->title;
?>

<h3><?= $this->title ?></h3><hr />

<?= Html::a('Registrar', ['/usuario/registrar'], ['class'=>'btn btn-success']) ?>

<div id="dialog-eliminar" title="Eliminar comisión">
    <p>
        <span id="dialog-eliminar-confirmacion"></span>
    </p>
    <div id="ruta-eliminar" style="display: none;"><?= Yii::getAlias('@web') ?></div>
</div>

<div class="filtros overflow-auto">
    <?php
    $createDateDatePicker = DatePicker::widget
    (
        [
            'model' => $searchModel,
            'attribute' => 'createDate',
            'template' => '{addon}{input}',
            'clientOptions' =>
                [
                    'autoclose' => true,
                    'format' => 'yyyy-mm-dd'
                ]
        ]
    );

    $recordDateDatePicker = DatePicker::widget
    (
        [
            'model' => $searchModel,
            'attribute' => 'recordDate',
            'template' => '{addon}{input}',
            'clientOptions' =>
                [
                    'autoclose' => true,
                    'format' => 'yyyy-MM-dd'
                ]
        ]
    );
    ?>

    <?= GridView::widget([
        'dataProvider' => $dataProvider,
        'filterModel' => $searchModel,
        'summary' => 'Visualizados {begin} - {end} de {totalCount} resultados',
        'emptyText' => 'No se encontraron resultados',
        'pager' => [
            'firstPageLabel' => '|<',
            'prevPageLabel' => '<<',
            'nextPageLabel' => '>>',
            'lastPageLabel' => '>|'
        ],
        'columns' => [
            [
                'class' => 'yii\grid\ActionColumn',
                'header' => 'Operaciones',
                'buttons' => [
                    'view' => function ($url, $model, $key) {
                        return Html::a('<span class="glyphicon glyphicon-eye-open"></span>', $url,
                            ['title' => 'Ver']);
                    },
                    'update' => function ($url, $model, $key) {
                        return Html::a('<span class="glyphicon glyphicon-edit"></span>', $url,
                            ['title' => 'Actualizar']);
                    },
                    'delete' => function ($url, $model, $key) {
                        return Html::a('<span class="glyphicon glyphicon-trash"></span>', $url,
                            ['class' => 'eliminar-usuario', 'title' => 'Eliminar', 'id' => $key, 'name' => $model->nombre .
                                ' ' . $model->primerApellido . ' ' . $model->segundoApellido]);
                    },
                ],
                'urlCreator' => function($action, $model, $key, $index) {
                    if($action === 'view')
                        return Yii::getAlias('@web') . '/usuario/ver?id=' . $model->idUsuario;
                    elseif($action == 'update')
                        return Yii::getAlias('@web') . '/usuario/actualizar?id=' . $model->idUsuario;
                    elseif($action == 'delete')
                        return 'javascript:;';
                }
            ],
            'usuario',
            'nombre',
            'primerApellido',
            'segundoApellido',
            [
                'attribute' => 'idSede',
                'value' => function ($model, $key, $index, $column) {
                    if(isset($model->sede))
                        return $model->sede->sede;
                    else
                        return "";
                },

                'filter' => $listaSedes,
            ],
            [
                'attribute' => 'idEstado',
                'value' => function ($model, $key, $index, $column) {
                    if(isset($model->estado))
                        return $model->estado->estado;
                    else
                        return "";
                },

                'filter' => $listaEstados,
            ],
            [
                'attribute' => 'idRolUsuario',
                'value' => function ($model, $key, $index, $column) {
                    if(isset($model->rolUsuario))
                        return $model->rolUsuario->rolUsuario;
                    else
                        return "";
                },

                'filter' => $listaRolesUsuario,
            ],
            [
                'attribute' => 'idEstatusUsuario',
                'value' => function ($model, $key, $index, $column) {
                    if(isset($model->estatusUsuario))
                        return $model->estatusUsuario->estatusUsuario;
                    else
                        return "";
                },

                'filter' => $listaEstatusUsuario,
            ],
            [
                'attribute' => 'createDate',
                'filter' => $createDateDatePicker,
            ],
            [
                'attribute' => 'recordDate',
                'filter' => $recordDateDatePicker,
            ],
        ],
    ]); ?>
</div>

<br />
<?= Html::a('Registrar', ['/usuario/registrar'], ['class'=>'btn btn-success']) ?>


 