<?php
/*
 * registrar.php
 * Springfield
 * Copyright ©: 2022 Integrasoft. Todos los derechos reservados.
 * Desarrollador(es):
 *      L.I. Humberto Javier Flores Tirado.
 * Fecha de creación: 25/03/2022.
 * Fecha de modificación: 17/05/2022.
 * Descripción:
 */

use yii\helpers\Html;
use yii\widgets\ActiveForm;

echo $this->registerJsFile
(
    '@web/js/usuario/registrar.js',
    ['depends' =>
        [
            \yii\web\JqueryAsset::className(),
            \yii\jui\JuiAsset::className()
        ]
    ]
);

$this->title = 'Registrar usuario';
$this->params['breadcrumbs'][] = ['label' => 'Usuario', 'url' => ['index']];
$this->params['breadcrumbs'][] = $this->title;

//Inicia el formulario
$form = ActiveForm::begin([
    'method' => 'post',
    'id' => 'usuario-form',
    'enableClientValidation' => false,
    'enableAjaxValidation' => true,
]);
?>

<h3><?= $this->title ?></h3><hr />

<div style="text-align: left; width: 100%">
    <?= Html::a('Regresar', ['/usuario/'], ['class'=>'btn btn-primary']) ?>
    &nbsp;
    <?= Html::submitButton('Guardar', ['class' => 'btn btn-success', 'title' => 'Guardar...']) ?>
</div>
<div id="web-root" style="display: none;"><?= Yii::getAlias('@web') ?></div>

<br />
<div class="group-form">
    <?= $form->field($model, 'idRolUsuario')->dropDownList($listaRolesUsuario, ['prompt' => 'Selecciona una opción...']) ?>
</div>

<div class="group-form">
    <?= $form->field($model, 'idEstatusUsuario')->dropDownList($listaEstatusUsuario, ['prompt' => 'Selecciona una opción...']) ?>
</div>

<div class="group-form">
    <?= $form->field($model, 'usuario')->input('text', ['maxlength' => 100, 'placeholder' => 'Introduce un usuario']) ?>
</div>

<div class="group-form">
    <?= $form->field($model, 'contrasenia')->input('password', ['maxlength' => 50, 'placeholder' => 'Introduce una contraseña']) ?>
</div>

<div class="group-form">
    <?= $form->field($model, 'confirmaContrasenia')->input('password', ['maxlength' => 50, 'placeholder' => 'Introduce la misma contraseña']) ?>
</div>

<div class="group-form">
    <?= $form->field($model, 'nombre')->input('text', ['maxlength' => 100, 'placeholder' => 'Introduce el nombre']) ?>
</div>

<div class="group-form">
    <?= $form->field($model, 'primerApellido')->input('text', ['maxlength' => 100, 'placeholder' => 'Introduce el primer apellido']) ?>
</div>

<div class="group-form">
    <?= $form->field($model, 'segundoApellido')->input('text', ['maxlength' => 100, 'placeholder' => 'Introduce el segundo apellido']) ?>
</div>

<div class="group-form">
    <?= $form->field($model, 'idEstado')->dropDownList($listaEstados, ['prompt' => 'Selecciona una opción...']) ?>
</div>

<div class="group-form">
    <?= $form->field($model, 'idSede')->dropDownList($listaSedes, ['prompt' => 'Selecciona una opción...']) ?>
</div>

<div style="text-align: left; width: 100%">
    <?= Html::a('Regresar', ['/usuario/'], ['class'=>'btn btn-primary']) ?>
    &nbsp;
    <?= Html::submitButton('Guardar', ['class' => 'btn btn-success', 'title' => 'Guardar...']) ?>
</div>


<?php $form->end(); ?>
